/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Signal;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.usage.NumericEditor;

public class SignalEditor
extends Editor {
    private static final long serialVersionUID = 1L;

    public static final boolean checkData(Descriptor<?> data) {
        return data instanceof Signal;
    }

    public SignalEditor(boolean editable, CTX ctx, Window window) {
        this(null, editable, ctx, window);
    }

    public SignalEditor(Descriptor<?> data, boolean editable, CTX ctx, Window window) {
        super(data, editable, ctx, 3);
        this.setLayout(new BorderLayout());
        JPanel columns = new JPanel(new GridLayout(1, 3));
        this.edit[0] = new NumericEditor(this.editable, ctx, window, "Data");
        columns.add(this.edit[0]);
        this.edit[1] = new NumericEditor(this.editable, ctx, window, "Raw");
        columns.add(this.edit[1]);
        this.edit[2] = new NumericEditor(this.editable, ctx, window, "Dimension");
        columns.add(this.edit[2]);
        this.add(columns);
        this.setData(data);
    }

    @Override
    public final Descriptor<?> getData() throws MdsException {
        return new Signal(new Descriptor[]{this.edit[0].getData(), this.edit[1].getData(), this.edit[2].getData()});
    }

    @Override
    public final void setData(Descriptor<?> data) {
        this.data = data;
        if (SignalEditor.checkData(data)) {
            this.setDescR();
        } else {
            this.edit[0].setData(data);
            this.edit[1].data = null;
            this.edit[2].data = null;
        }
    }
}

