/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Param;
import mds.data.descriptor_r.With_Units;
import mds.jtraverser.editor.Editor;
import mds.jtraverser.editor.ExprEditor;

public class ParameterEditor
extends Editor {
    private static final long serialVersionUID = 1L;
    private final ExprEditor help;
    private final ExprEditor validation;
    private final ExprEditor units;
    private final Editor value;

    public static final boolean hasParams(Descriptor<?> data) {
        return data instanceof With_Units || data instanceof Param;
    }

    public ParameterEditor(Descriptor<?> data, boolean editable, CTX ctx) {
        this(data, editable, ctx, new ExprEditor(editable, ctx, false, true));
    }

    public ParameterEditor(Descriptor<?> data, boolean editable, CTX ctx, Editor value) {
        super(data, editable, ctx, 0);
        this.value = value;
        this.units = new ExprEditor(editable, ctx, true, false);
        this.help = new ExprEditor(editable, ctx, true, false);
        this.validation = new ExprEditor(editable, ctx, false, false);
        this.setLayout(new BorderLayout());
        this.add((Component)Editor.addLabel("Value", this.value), "Center");
        JPanel jp = new JPanel(new GridLayout(3, 1));
        jp.add(Editor.addLabel("Units", this.units));
        jp.add(Editor.addLabel("Help", this.help));
        jp.add(Editor.addLabel("Validation", this.validation));
        this.add((Component)jp, "Last");
        if (!Editor.isNoData(this.data)) {
            this.setData(data);
        }
    }

    @Override
    public final Descriptor<?> getData() throws MdsException {
        Descriptor<?> unitout = this.units.getData();
        Descriptor<?> helpout = this.help.getData();
        Descriptor<?> validout = this.validation.getData();
        With_Units valueout = Editor.isNoData(unitout) ? this.value.getData() : new With_Units(this.value.getData(), unitout);
        if (Editor.isNoData(helpout) && Editor.isNoData(validout)) {
            return valueout;
        }
        return new Param((Descriptor)valueout, helpout, validout);
    }

    @Override
    public final void setData(Descriptor<?> data) {
        if (data instanceof Param) {
            Param param = (Param)data;
            this.help.setData(param.getHelp());
            this.validation.setData(param.getValidation());
            Descriptor pvalue = param.getValue();
            if (pvalue instanceof With_Units) {
                With_Units with_units = (With_Units)pvalue;
                this.value.setData(with_units.getValue());
                this.units.setData(with_units.getUnits());
            } else {
                this.value.setData(pvalue);
            }
        } else if (data instanceof With_Units) {
            With_Units with_units = (With_Units)data;
            this.units.setData(with_units.getUnits());
            Descriptor uvalue = with_units.getValue();
            if (uvalue instanceof Param) {
                Param param = (Param)uvalue;
                this.value.setData(param.getValue());
                this.help.setData(param.getHelp());
                this.validation.setData(param.getValidation());
            } else {
                this.value.setData(uvalue);
            }
        } else {
            this.value.setData(data);
        }
    }
}

