/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import mds.Mds;
import mds.MdsException;
import mds.data.CTX;
import mds.data.DTYPE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor.Descriptor_R;
import mds.data.descriptor_r.Signal;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.NUMBER;
import mds.jtraverser.dialogs.DataDialog;
import mds.jtraverser.dialogs.GraphPanel;

public abstract class Editor
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected final boolean editable;
    protected final Editor[] edit;
    protected Descriptor<?> data;
    protected CTX ctx;
    private Descriptor<?> value;

    public static JPanel addButtons(final Editor editor, final NODE<?> node) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)editor, "Center");
        Insets insets = new Insets(-3, 3, -3, 3);
        JPanel buttons = new JPanel(new GridLayout(0, 1));
        if (editor.editable) {
            JButton apply = new JButton("A");
            apply.setMargin(insets);
            apply.setToolTipText("apply");
            apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        Descriptor<?> newdata = editor.getData();
                        node.putRecord(newdata);
                        editor.setData(newdata);
                    }
                    catch (MdsException e) {
                        JOptionPane.showMessageDialog(editor, e.getMessage(), "Apply", 2);
                    }
                }
            });
            JButton reset = new JButton("R");
            reset.setMargin(insets);
            reset.setToolTipText("reset");
            reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        editor.setData(node.getRecord());
                    }
                    catch (MdsException e) {
                        editor.reset(false);
                    }
                }
            });
            buttons.add(apply);
            buttons.add(reset);
        }
        JButton openedit = new JButton("E");
        openedit.setMargin(insets);
        openedit.setToolTipText("editor");
        openedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    DataDialog dialog = DataDialog.open(node, editor.editable);
                    dialog.addUpdateListener(new DataDialog.UpdateListener(){

                        @Override
                        public void update(Descriptor<?> data) {
                            editor.setData(data);
                        }
                    });
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(editor, e.getMessage(), "Open Editor", 2);
                }
            }
        });
        buttons.add(openedit);
        panel.add((Component)buttons, "After");
        return panel;
    }

    public static final <T extends JComponent> T addLabel(String label, T editor) {
        editor.setBorder(BorderFactory.createTitledBorder(label));
        return editor;
    }

    public static JPopupMenu addTextEditorActions(JPopupMenu menu, boolean editable) {
        if (editable) {
            DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
            cut.putValue("Name", "Cut");
            cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
            menu.add(cut);
        }
        DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", "Copy");
        copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        menu.add(copy);
        if (editable) {
            DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
            paste.putValue("Name", "Paste");
            paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
            menu.add(paste);
        }
        menu.add(new SelectAll());
        return menu;
    }

    protected static final boolean isNoData(Descriptor<?> data) {
        return data == null || data.dtype() == DTYPE.Z;
    }

    public static JPopupMenu newTextEditorPopup(boolean editable) {
        return Editor.addTextEditorActions(new JPopupMenu(), editable);
    }

    protected Editor(Descriptor<?> data, boolean editable, CTX ctx, int nargs) {
        this.data = data;
        this.editable = editable;
        this.edit = new Editor[nargs];
        this.ctx = ctx;
    }

    public abstract Descriptor<?> getData() throws MdsException;

    protected Mds getMds() {
        Mds mds = this.ctx.getMds();
        if (mds != null) {
            return mds;
        }
        return Mds.getActiveMds();
    }

    protected NUMBER<?> getNumber() throws MdsException {
        Descriptor num = this.getData().getDataD();
        if (num instanceof NUMBER) {
            return (NUMBER)num;
        }
        throw new MdsException(265519290);
    }

    public void interrupt() {
    }

    public boolean isNull() {
        return false;
    }

    public void reset(boolean hard) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Editor)) continue;
            ((Editor)component).reset(hard);
        }
    }

    public void setData(Descriptor<?> data) {
        this.data = data;
        this.reset(false);
    }

    protected final void setDescR() {
        if (this.data instanceof Descriptor_R) {
            Descriptor_R dsc_r = (Descriptor_R)this.data;
            for (int i = 0; i < this.edit.length; ++i) {
                this.edit[i].setData(dsc_r.getDescriptor(i));
            }
        } else {
            for (Editor element : this.edit) {
                element.setData(null);
            }
        }
    }

    public final void setValue(Descriptor<?> value) {
        this.value = value;
    }

    private static class SelectAll
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public SelectAll() {
            super("Select All");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = (JPopupMenu)((Component)e.getSource()).getParent();
            JTextComponent component = (JTextComponent)menu.getInvoker();
            component.requestFocusInWindow();
            component.selectAll();
        }
    }

    public static enum POPUP_MODE {
        CONTEXT,
        CLICK;

    }

    protected final class EvalPopupMenu
    extends JPopupMenu
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        final POPUP_MODE mode;

        public EvalPopupMenu(POPUP_MODE mode) {
            this.mode = mode;
            if (mode == POPUP_MODE.CONTEXT) {
                Editor.addTextEditorActions(this, Editor.this.editable);
                this.addSeparator();
            }
            JMenuItem item = new JMenuItem("DATA($)");
            this.add(item);
            item.addActionListener(new EvalActionListener(Editor.this, "DATA($)"));
            item = new JMenuItem("RAW_OF($)");
            this.add(item);
            item.addActionListener(new EvalActionListener(Editor.this, "RAW_OF($)"));
            item = new JMenuItem("DIM_OF($)");
            this.add(item);
            item.addActionListener(new EvalActionListener(Editor.this, "DIM_OF($)"));
            item = new JMenuItem("Plot DATA($)");
            this.add(item);
            item.addActionListener(new DisplaySignal());
        }

        String escapeHTML(String s) {
            StringBuilder out = new StringBuilder(Math.max(16, s.length()));
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                    out.append("&#");
                    out.append((int)c);
                    out.append(';');
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (POPUP_MODE.CLICK == this.mode) {
                this.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (POPUP_MODE.CONTEXT == this.mode && e.isPopupTrigger()) {
                this.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }

        protected class EvalActionListener
        implements ActionListener {
            private final String exec;

            EvalActionListener(Editor editor, String exec) {
                this.exec = exec;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String aeeval;
                if (this.exec == null) {
                    aeeval = MdsException.getMdsMessage((int)265519194);
                } else {
                    try {
                        Descriptor aedata = Editor.this.getMds().getDescriptor(Editor.this.ctx, this.exec, new Descriptor[]{Editor.this.getData()});
                        aeeval = Descriptor.isMissing((Descriptor)aedata) ? "*" : aedata.toString();
                    }
                    catch (MdsException de) {
                        aeeval = de.getMessage();
                    }
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(aeeval), null);
                JOptionPane.showMessageDialog(Editor.this, "<html><body><p style='width: 360px;'>" + EvalPopupMenu.this.escapeHTML(aeeval) + "</p></body></html>", "Evaluated Data (also copied to Clipboard)", -1);
            }
        }

        public final class DisplaySignal
        implements ActionListener {
            @Override
            public final void actionPerformed(ActionEvent ae) {
                try {
                    Descriptor local = Descriptor.isMissing((Descriptor)Editor.this.value) ? Editor.this.getData().getLocal() : new Signal(new Descriptor[]{Editor.this.getData(), Editor.this.value.getLocal(), null}).getLocal();
                    GraphPanel.newPlot(local.toFloatArray(), null, JOptionPane.getRootFrame(), Editor.this.getName()).setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

