/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor.Descriptor_CA;
import mds.data.descriptor_a.NUMBERArray;
import mds.jtraverser.dialogs.GraphPanel;
import mds.jtraverser.editor.Editor;

public class ArrayEditor
extends Editor
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private final JTable table = new JTable();
    private final JTable rows;
    private Thread updater;
    private HashMap<Integer, Number> changes;
    private JSlider slider;
    private JSpinner[] coord_edit;
    private JPanel dimcontrol;

    public static final boolean checkData(Descriptor<?> data) {
        return data instanceof NUMBERArray || data instanceof Descriptor_CA;
    }

    public ArrayEditor(boolean editable, CTX ctx) {
        this(null, editable, ctx);
    }

    public ArrayEditor(Descriptor<?> data, boolean editable, CTX ctx) {
        super(data, editable, ctx, 0);
        this.table.setAutoResizeMode(4);
        this.table.setDoubleBuffered(true);
        this.rows = new RowNumberTable(this.table);
        JScrollPane scroll_panel = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)scroll_panel, "Center");
        scroll_panel.setRowHeaderView(this.rows);
        scroll_panel.setVerticalScrollBarPolicy(22);
        scroll_panel.setCorner("UPPER_LEFT_CORNER", this.rows.getTableHeader());
        this.setPreferredSize(new Dimension(240, 640));
        if (!Editor.isNoData(this.data)) {
            this.setData(data);
        }
        JButton plot = new JButton("Plot");
        plot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultTableModel model = (DefaultTableModel)ArrayEditor.this.table.getModel();
                float[] dat = new float[model.getRowCount()];
                for (int i = 0; i < dat.length; ++i) {
                    dat[i] = ((Number)model.getValueAt(i, 0)).floatValue();
                }
                GraphPanel.newPlot(dat, null, JOptionPane.getRootFrame(), ArrayEditor.this.getTitle());
            }
        });
        this.add((Component)plot, "South");
    }

    @Override
    public Descriptor<?> getData() throws MdsException {
        if (!(this.data instanceof NUMBERArray)) {
            return this.data;
        }
        NUMBERArray new_data = (NUMBERArray)this.data;
        for (Map.Entry<Integer, Number> entry : this.changes.entrySet()) {
            new_data.setAtomic(entry.getKey().intValue(), entry.getValue());
        }
        this.data = new_data;
        return this.data;
    }

    private final String getTitle() {
        if (this.dimcontrol == null) {
            return "Array";
        }
        StringBuilder sb = new StringBuilder(256).append("Slice( ");
        for (int i = 0; i < this.coord_edit.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            if (this.slider.getValue() == i) {
                sb.append(':');
                continue;
            }
            sb.append(this.coord_edit[i].getValue());
        }
        return sb.append(" )").toString();
    }

    public final boolean hasChanged() {
        return !this.changes.isEmpty();
    }

    @Override
    public final void interrupt() {
        if (this.updater != null && this.updater.isAlive()) {
            this.updater.interrupt();
        }
    }

    @Override
    public final void reset(boolean hard) {
        int inc;
        int dim;
        int offset;
        if (this.updater != null && this.updater.isAlive()) {
            this.updater.interrupt();
        }
        if (Editor.isNoData(this.data)) {
            return;
        }
        if (hard) {
            int[] dims;
            if (this.dimcontrol != null) {
                this.remove(this.dimcontrol);
            }
            if ((dims = this.data.getShape()).length > 1) {
                boolean dim2 = false;
                this.dimcontrol = new JPanel(new BorderLayout());
                this.slider = new JSlider(0, dims.length - 1, 0);
                this.dimcontrol.add((Component)this.slider, "West");
                this.slider.setMajorTickSpacing(1);
                this.slider.setPaintTicks(true);
                this.slider.setPaintLabels(true);
                this.slider.setOrientation(1);
                this.slider.setToolTipText("Slice array along this dimension. Time is the last dimension.");
                this.slider.addChangeListener(this);
                this.slider.setBorder(new EmptyBorder(3, 0, 3, 0));
                this.slider.setPreferredSize(new Dimension(60, 20 * dims.length - 6));
                this.slider.setInverted(true);
                JPanel coord = new JPanel(new GridLayout(dims.length, 2));
                coord.setMinimumSize(new Dimension(180, 0));
                this.dimcontrol.add((Component)coord, "Center");
                this.coord_edit = new JSpinner[dims.length];
                for (int i = 0; i < dims.length; ++i) {
                    JSpinner ce = this.coord_edit[i] = new JSpinner(new SpinnerNumberModel(0, 0, dims[i] - 1, 1));
                    ce.addChangeListener(this);
                    coord.add(ce);
                    JLabel label = new JLabel(String.valueOf(dims[i]));
                    label.setHorizontalAlignment(0);
                    coord.add(label);
                }
                this.coord_edit[0].setEnabled(false);
                this.add((Component)this.dimcontrol, "North");
            } else {
                this.dimcontrol = null;
                this.slider = null;
                this.coord_edit = null;
            }
            this.validate();
            this.repaint();
        }
        if (!(this.data instanceof NUMBERArray)) {
            return;
        }
        final NUMBERArray narray = (NUMBERArray)this.data;
        final int[] dims = narray.getShape();
        this.changes = new HashMap();
        final TableColumn column = this.rows.getColumn(this.rows);
        final JTableHeader header = this.rows.getTableHeader();
        final DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return ArrayEditor.this.editable;
            }

            @Override
            public final void setValueAt(Object value, int row, int col) {
                if (col > 0) {
                    return;
                }
                try {
                    Number number = narray.parse(value.toString());
                    ArrayEditor.this.changes.put(row, number);
                    super.setValueAt(number, row, col);
                }
                catch (Exception e) {
                    System.err.println(e + ": " + e.getMessage());
                    ArrayEditor.this.setToolTipText(e.getMessage());
                }
            }
        };
        model.addColumn(this.data.getDTypeName());
        this.table.setModel(model);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (this.slider == null) {
            offset = 0;
            dim = 0;
            inc = 1;
        } else {
            dim = this.slider.getValue();
            int[] coord = new int[dims.length];
            for (int i = 0; i < dims.length; ++i) {
                coord[i] = (Integer)this.coord_edit[i].getValue();
            }
            int toffset = 0;
            int tinc = 1;
            int i = 0;
            int j = 1;
            while (i < dims.length) {
                if (dim == i) {
                    tinc = j;
                } else {
                    toffset += j * coord[i];
                }
                j *= dims[i++];
            }
            offset = toffset;
            inc = tinc;
        }
        this.updater = new Thread("ArrayEditor.updater"){
            {
                super(x0);
                this.setDaemon(true);
                this.setPriority(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                int n = dims.length > 0 ? dims[dim] : 1;
                for (int i = 0; i < n; ++i) {
                    if (i % 10000 == 0 && n > 10000) {
                        column.setHeaderValue(new StringBuilder(4).append(100 * i / n).append('%').toString());
                        header.repaint();
                        3 var3_3 = this;
                        synchronized (var3_3) {
                            if (this.isInterrupted()) {
                                return;
                            }
                        }
                    }
                    model.addRow(new Number[]{narray.get(i * inc + offset)});
                }
                column.setHeaderValue("");
                header.repaint();
            }
        };
        this.updater.start();
    }

    @Override
    public final void setData(Descriptor<?> data) {
        if (data instanceof Descriptor_CA) {
            data = ((Descriptor_CA)data).unpack();
        }
        this.data = data;
        this.reset(true);
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        if (this.slider != null) {
            int dim = this.slider.getValue();
            for (int i = 0; i < this.coord_edit.length; ++i) {
                this.coord_edit[i].setEnabled(i != dim);
            }
        }
        this.reset(false);
    }

    public class RowNumberTable
    extends JTable
    implements ChangeListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final JTable main;

        public RowNumberTable(JTable table) {
            this.main = table;
            this.main.addPropertyChangeListener(this);
            this.main.getModel().addTableModelListener(this);
            this.setFocusable(false);
            this.setAutoCreateColumnsFromModel(false);
            this.setSelectionModel(this.main.getSelectionModel());
            TableColumn column = new TableColumn();
            column.setIdentifier(this);
            column.setHeaderValue("");
            this.addColumn(column);
            column.setCellRenderer(new RowNumberRenderer());
            this.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            Container c = this.getParent();
            if (c instanceof JViewport) {
                JViewport viewport = (JViewport)c;
                viewport.addChangeListener(this);
            }
        }

        @Override
        public int getRowCount() {
            return this.main.getRowCount();
        }

        @Override
        public int getRowHeight(int row) {
            int row_height = this.main.getRowHeight(row);
            if (row_height != super.getRowHeight(row)) {
                super.setRowHeight(row, row_height);
            }
            return row_height;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return Integer.toString(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return ArrayEditor.this.editable;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selectionModel".equals(e.getPropertyName())) {
                this.setSelectionModel(this.main.getSelectionModel());
            }
            if ("rowHeight".equals(e.getPropertyName())) {
                this.repaint();
            }
            if (!"model".equals(e.getPropertyName())) {
                return;
            }
            this.main.getModel().addTableModelListener(this);
            this.revalidate();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            JScrollPane scrollPane = (JScrollPane)viewport.getParent();
            scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.revalidate();
        }

        private class RowNumberRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            public RowNumberRenderer() {
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table_in, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table_in != null && (header = table_in.getTableHeader()) != null) {
                    RowNumberTable.this.setForeground(header.getForeground());
                    RowNumberTable.this.setBackground(header.getBackground());
                    RowNumberTable.this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                RowNumberTable.this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        }
    }
}

