/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import mds.MdsException;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_a.Int32Array;
import mds.data.descriptor_s.Nid;
import mds.jtraverser.Node;
import mds.jtraverser.TreeManager;
import mds.jtraverser.TreeView;
import mds.jtraverser.dialogs.CheckBoxList;

public class SubTreeList
extends CheckBoxList {
    private static final long serialVersionUID = 1L;

    public SubTreeList(TreeManager treeman) {
        super(treeman, "SubTrees include in Pulse");
    }

    @Override
    protected void apply() {
        TreeView tree = this.treeman.getCurrentTreeView();
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox cb = (JCheckBox)this.checkboxes.getElementAt(i);
            if (cb.isSelected() == ((Boolean)cb.getClientProperty("old")).booleanValue()) continue;
            Nid nid = (Nid)cb.getClientProperty("nid");
            DefaultMutableTreeNode treenode = tree.findPath((String)cb.getClientProperty("fullpath"));
            try {
                if (cb.isSelected()) {
                    nid.setFlags(32768);
                } else {
                    nid.clearFlags(32768);
                }
                if (treenode == null) continue;
                ((Node)treenode.getUserObject()).readFlags();
                continue;
            }
            catch (MdsException me) {
                MdsException.stderr((String)"SubTreeList.apply", (Exception)((Object)me));
            }
        }
        tree.reportChange();
        this.update();
    }

    @Override
    public final void update() {
        super.update();
        if (this.treeview.getMds().isLowLatency()) {
            int[] nid = new int[this.checkboxes.size()];
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                nid[i] = ((Nid)((JCheckBox)this.checkboxes.getElementAt(i)).getClientProperty("nid")).getNidNumber();
            }
            try {
                int[] flag = this.treeview.getMds().getIntegerArray((CTX)this.treeview.getTree().ctx, "GETNCI($,'GET_FLAGS')", new Descriptor[]{new Int32Array(nid)});
                for (int i = 0; i < this.checkboxes.size(); ++i) {
                    ((JCheckBox)this.checkboxes.getElementAt(i)).setSelected((flag[i] & 0x8000) != 0);
                }
            }
            catch (MdsException e) {
                MdsException.stderr((String)"SubTreeList.update", (Exception)((Object)e));
            }
        } else {
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                JCheckBox cb = (JCheckBox)this.checkboxes.getElementAt(i);
                Nid nid = (Nid)cb.getClientProperty("nid");
                try {
                    cb.setSelected((nid.getNciFlags() & 0x8000) != 0);
                    continue;
                }
                catch (MdsException mdsException) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            ((JCheckBox)this.checkboxes.getElementAt(i)).putClientProperty("old", ((JCheckBox)this.checkboxes.getElementAt(i)).isSelected());
        }
        this.repaint();
    }

    @Override
    protected final void updatelist() {
        this.updatelist((byte)11);
    }
}

