/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mds.MdsException;
import mds.MdsMisc;
import mds.data.CTX;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Signal;
import mds.data.descriptor_s.NODE;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final boolean yaxis = false;
    private static final boolean xaxis = true;
    private static final Stroke GRAPH_STROKE = new BasicStroke(2.0f);
    private static final Color gridColor = new Color(200, 200, 200, 200);
    private static final Color lineColor = new Color(0, 0, 255, 180);
    private static final int labelPadding = 25;
    private static final int numberYDivisions = 10;
    private static final int padding = 25;
    private static final int pointWidth = 4;
    private static final int padding_total = 75;
    private static final boolean use_new_misc = false;
    private List<XY> scores;

    private static final void drawGraph(Graphics2D g2, List<Point> curve) {
        Stroke oldStroke = g2.getStroke();
        g2.setColor(lineColor);
        g2.setStroke(GRAPH_STROKE);
        for (int i = 0; i < curve.size() - 1; ++i) {
            g2.drawLine(curve.get((int)i).x, curve.get((int)i).y, curve.get((int)(i + 1)).x, curve.get((int)(i + 1)).y);
        }
        g2.setStroke(oldStroke);
    }

    private static final List<XY> getScores(float[] x, float[] y, int imax) {
        if (y == null) {
            return null;
        }
        int len_in = x == null ? y.length : x.length;
        double p = (double)(x == null ? (float)(len_in - 1) : x[x.length - 1] - x[0]) / ((double)imax * 2.0);
        double v = p - Double.MIN_VALUE + (double)(x == null ? 0.0f : x[0]);
        if (y.length / imax > 5) {
            ArrayList<XY> new_scores = new ArrayList<XY>(imax * 2);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            int th = 0;
            for (int i = 0; i < len_in; ++i) {
                if (min > y[i]) {
                    min = y[i];
                }
                if (max < y[i]) {
                    max = y[i];
                }
                ++th;
                if (i + 1 < len_in) {
                    float f = x == null ? (float)(i + 1) : x[i + 1];
                    if (!((double)f >= v)) continue;
                }
                if (th > 2) {
                    new_scores.add(new XY((float)(v - p / 2.0), max));
                    new_scores.add(new XY((float)(v - p / 2.0), min));
                } else {
                    while (th-- > 0) {
                        new_scores.add(new XY(x == null ? (float)(i - th) : x[i - th], y[i - th]));
                    }
                }
                max = Float.NEGATIVE_INFINITY;
                min = Float.POSITIVE_INFINITY;
                v += p;
                th = 0;
            }
            return new_scores;
        }
        if (x == null) {
            ArrayList<XY> new_scores = new ArrayList<XY>(y.length);
            for (int i = 0; i < y.length; ++i) {
                new_scores.add(new XY(i, y[i]));
            }
            return new_scores;
        }
        ArrayList<XY> new_scores = new ArrayList<XY>(x.length);
        for (int i = 0; i < x.length; ++i) {
            new_scores.add(new XY(x[i], y[i]));
        }
        return new_scores;
    }

    public static final JDialog newPlot(Descriptor<?> sig, Frame frame, String title) {
        float[] dim;
        float[] dat;
        float[] fArray = dat = (sig = sig.getLocal()) != null ? sig.toFloatArray() : null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        float[] fArray2 = dim = sig instanceof Signal ? ((Signal)sig).getDimension().toFloatArray() : null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return GraphPanel.newPlot(dat, dim, frame, title);
    }

    public static final JDialog newPlot(Descriptor<?> sig, Frame frame, String tree, long shot, String expr) {
        String title = new StringBuilder(expr.length() + tree.length() + 10).append(expr).append(" @ Tree(").append(tree).append(',').append(shot).append(')').toString();
        return GraphPanel.newPlot(sig, frame, title);
    }

    public static JDialog newPlot(float[] dat, float[] dim, Frame frame, String title) {
        JDialog dialog = new JDialog(frame, title);
        GraphPanel gp = new GraphPanel();
        dialog.getContentPane().add(gp);
        dialog.pack();
        gp.setScores(dim, dat);
        if (Thread.currentThread().isInterrupted()) {
            dialog.dispose();
            return null;
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(frame);
        dialog.setVisible(true);
        return dialog;
    }

    public static final void plotNode(NODE<?> node, Frame frame, String title) {
        try {
            MdsMisc misc = new MdsMisc(node.getTree().getMds());
            String expr = node.decompile();
            MdsMisc.DataStruct ds = misc.miscGetXYSignalLongTimes((CTX)node.getTree(), "__s=" + expr, "DIM_OF(__s)", Long.MIN_VALUE, Long.MAX_VALUE, 3200);
            GraphPanel.newPlot(ds.y, ds.to_float(), frame, title);
        }
        catch (MdsException.MdsAbortException misc) {
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Display Signal", 0);
        }
    }

    public static final void plotNodeSig(NODE<?> node, Frame frame, String title) {
        try {
            NODE datanode = node.followReference();
            Descriptor sig = datanode.getRecord();
            GraphPanel.newPlot(sig, frame, title);
        }
        catch (MdsException.MdsAbortException datanode) {
        }
        catch (MdsException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Display Signal", 0);
        }
    }

    public GraphPanel() {
        this((List<XY>)null);
    }

    public GraphPanel(List<XY> scores) {
        this.setPreferredSize(new Dimension(800, 400));
        this.scores = scores;
    }

    private final void drawAxes(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(this.getOrigin(true), 25, this.getSize(true), -this.getSize(false));
        Params paramsX = this.getParams(true);
        Params paramsY = this.getParams(false);
        this.drawAxis(g2, paramsX);
        this.drawAxis(g2, paramsY);
        this.drawScore(g2, paramsX, paramsY);
    }

    private final void drawAxis(Graphics2D g2, Params params) {
        int b0 = this.getOrigin(!params.isX);
        int bt = b0 + (params.isX ? -4 : 4);
        int b1 = b0 + this.getSize(!params.isX);
        for (int i = 0; i <= 10; ++i) {
            float rel = (float)i / 10.0f;
            float value = params.min + params.delta * rel;
            int a = this.getPoint(rel, params.isX);
            g2.setColor(i > 0 ? gridColor : Color.BLACK);
            if (params.isX) {
                g2.drawLine(a, bt - 1, a, b1);
            } else {
                g2.drawLine(bt + 1, a, b1, a);
            }
            g2.setColor(Color.BLACK);
            String label = String.format("%.2g", Float.valueOf(value));
            FontMetrics metrics = g2.getFontMetrics();
            int labelWidth = metrics.stringWidth(label);
            if (params.isX) {
                g2.drawString(label, a - labelWidth / 2, b0 + metrics.getHeight() + 3);
                g2.drawLine(a, b0, a, bt);
                continue;
            }
            g2.drawString(label, bt - labelWidth - 7, a + metrics.getHeight() / 2 - 3);
            g2.drawLine(b0, a, bt, a);
        }
    }

    private final void drawScore(Graphics2D g2, Params paramsX, Params paramsY) {
        ArrayList<Point> curve = new ArrayList<Point>();
        for (int i = 0; i < this.scores.size(); ++i) {
            curve.add(this.getPoint(i, paramsX, paramsY));
        }
        GraphPanel.drawGraph(g2, curve);
    }

    private final int getOrigin(boolean isX) {
        if (isX) {
            return 50;
        }
        return 25 - this.getSize(isX);
    }

    private final Params getParams(boolean isX) {
        if (isX) {
            return new Params(this.scores.get((int)0).X, this.scores.get((int)(this.scores.size() - 1)).X, isX);
        }
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (XY pair : this.scores) {
            if (min > pair.Y) {
                min = pair.Y;
            }
            if (!(max < pair.Y)) continue;
            max = pair.Y;
        }
        if (min < max) {
            return new Params(min, max, isX);
        }
        return new Params(min - 0.5f, max + 0.5f, isX);
    }

    private final int getPoint(float rel, boolean isX) {
        return this.getOrigin(isX) + (int)(rel * (float)this.getSize(isX));
    }

    private final int getPoint(int idx, Params params) {
        float val = params.isX ? this.scores.get((int)idx).X : this.scores.get((int)idx).Y;
        return this.getPoint((val - params.min) / params.delta, params.isX);
    }

    private final Point getPoint(int idx, Params paramsX, Params paramsY) {
        return new Point(this.getPoint(idx, paramsX), this.getPoint(idx, paramsY));
    }

    public final List<XY> getScores() {
        return this.scores;
    }

    private final int getSize(boolean isX) {
        return isX ? this.getWidth() - 75 : 75 - this.getHeight();
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.scores == null || this.scores.size() == 0) {
            g.drawString("no data", this.getWidth() / 2, this.getHeight() / 2);
        } else if (this.scores.size() == 1) {
            g.drawString(this.scores.get(0).toString(), this.getWidth() / 2, this.getHeight() / 2);
        } else {
            this.drawAxes((Graphics2D)g);
        }
    }

    public final void setScores(float[] x, float[] y) {
        this.setScores(GraphPanel.getScores(x, y, this.getWidth()));
    }

    public final void setScores(List<XY> scores) {
        this.scores = scores;
        this.invalidate();
        this.repaint();
    }

    private static final class XY {
        public final float X;
        public final float Y;

        public XY(float X, float Y) {
            this.X = X;
            this.Y = Y;
        }

        public final String toString() {
            return new StringBuilder(64).append('(').append(this.X).append(", ").append(this.Y).append(')').toString();
        }
    }

    private static final class Params {
        public final float min;
        public final float delta;
        public final boolean isX;

        public Params(float min, float max, boolean isX) {
            this.min = min;
            this.delta = max - min;
            this.isX = isX;
        }
    }
}

