/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mds.MdsException;
import mds.data.descriptor_s.NODE;
import mds.jtraverser.Node;
import mds.jtraverser.TreeManager;
import mds.jtraverser.dialogs.Dialogs;

public final class FlagsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JButton close_b;
    private final JCheckBox[] flag;
    private final boolean[] settable_flag = new boolean[]{true, false, true, true, false, false, true, true, false, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false};
    private final TreeManager treeman;
    private final JButton update_b;

    private static final boolean[] intToBool(int iflags) {
        boolean[] bflags = new boolean[32];
        for (int i = 0; i < 32; i = (int)((byte)(i + 1))) {
            bflags[i] = (iflags & 1 << i) != 0;
        }
        return bflags;
    }

    public FlagsDialog(TreeManager treeman) {
        super(JOptionPane.getRootFrame());
        byte i;
        this.treeman = treeman;
        this.setFocusableWindowState(false);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel jp1 = new JPanel();
        jp1.setLayout(new GridLayout(8, 4));
        this.flag = new JCheckBox[32];
        this.flag[13] = new JCheckBox("PathReference");
        jp1.add(this.flag[13]);
        this.flag[14] = new JCheckBox("NidReference");
        jp1.add(this.flag[14]);
        this.flag[5] = new JCheckBox("Segmented");
        jp1.add(this.flag[5]);
        this.flag[8] = new JCheckBox("Compressible");
        jp1.add(this.flag[8]);
        this.flag[1] = new JCheckBox("ParentOff");
        jp1.add(this.flag[1]);
        this.flag[4] = new JCheckBox("Versions");
        jp1.add(this.flag[4]);
        this.flag[16] = new JCheckBox("CompressSegments");
        jp1.add(this.flag[16]);
        this.flag[9] = new JCheckBox("DoNotCompress");
        jp1.add(this.flag[9]);
        this.flag[0] = new JCheckBox("Off");
        jp1.add(this.flag[0]);
        this.flag[6] = new JCheckBox("Setup");
        jp1.add(this.flag[6]);
        this.flag[2] = new JCheckBox("Essential");
        jp1.add(this.flag[2]);
        this.flag[10] = new JCheckBox("CompressOnPut");
        jp1.add(this.flag[10]);
        this.flag[11] = new JCheckBox("NoWriteModel");
        jp1.add(this.flag[11]);
        this.flag[12] = new JCheckBox("NoWriteShot");
        jp1.add(this.flag[12]);
        this.flag[7] = new JCheckBox("WriteOnce");
        jp1.add(this.flag[7]);
        this.flag[15] = new JCheckBox("IncludeInPulse");
        jp1.add(this.flag[15]);
        this.flag[3] = new JCheckBox("Cached");
        jp1.add(this.flag[3]);
        for (i = 17; i < 31; i = (byte)((byte)(i + 1))) {
            this.flag[i] = new JCheckBox("UndefinedFlag" + i);
            jp1.add(this.flag[i]);
        }
        this.flag[31] = new JCheckBox("Error");
        jp1.add(this.flag[31]);
        this.flag[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node currnode = FlagsDialog.this.treeman.getCurrentNode();
                if (currnode == null) {
                    return;
                }
                if (FlagsDialog.this.flag[0].isSelected()) {
                    currnode.turnOff();
                } else {
                    currnode.turnOn();
                }
                FlagsDialog.this.treeman.reportChange();
            }
        });
        for (i = 1; i < 32; i = (byte)((byte)(i + 1))) {
            if (this.flag[i] == null) continue;
            final byte ii = i;
            this.flag[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlagsDialog.this.editFlag(ii);
                    FlagsDialog.this.treeman.reportChange();
                }
            });
        }
        jp.add(jp1);
        JPanel jp3 = new JPanel();
        jp3.setLayout(new GridLayout(1, 2));
        this.close_b = new JButton("Close");
        jp3.add(this.close_b);
        this.close_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlagsDialog.this.close();
            }
        });
        this.update_b = new JButton("Refresh");
        jp3.add(this.update_b);
        this.update_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlagsDialog.this.update();
            }
        });
        jp.add((Component)jp3, "South");
        this.getContentPane().add(jp);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FlagsDialog.this.setVisible(false);
                }
            }
        });
        this.pack();
        this.setResizable(false);
    }

    public final void close() {
        this.dispose();
    }

    private final void editFlag(byte idx) {
        Node currnode = this.treeman.getCurrentTreeView().getCurrentNode();
        if (currnode == null) {
            return;
        }
        if (this.flag[idx].isSelected()) {
            try {
                currnode.setFlag(idx);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, exc.getMessage(), "Error setting flag" + idx, 2);
            }
        } else {
            try {
                currnode.clearFlag(idx);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, exc.getMessage(), "Error clearing flag " + idx, 2);
            }
        }
        this.update();
    }

    public final void open() {
        Dialogs.setLocation(this);
        this.setVisible(true);
        this.update();
    }

    private NODE.Flags readFlags() throws Exception {
        Node currnode = this.treeman.getCurrentTreeView().getCurrentNode();
        if (currnode == null) {
            return new NODE.Flags();
        }
        NODE.Flags flags = currnode.getFlags();
        if (flags.isError()) {
            MdsException.stderr((String)"Error getting Flags", null);
        }
        return flags;
    }

    public final void update() {
        int iflags;
        if (!this.isVisible()) {
            return;
        }
        try {
            iflags = this.readFlags().flags;
        }
        catch (Exception exc) {
            MdsException.stderr((String)"Error getting flags", (Exception)exc);
            this.close();
            return;
        }
        boolean[] bflags = FlagsDialog.intToBool(iflags);
        Node currnode = this.treeman.getCurrentMdsView().getCurrentNode();
        boolean is_ok = !this.treeman.getCurrentTreeView().isReadOnly() && currnode != null;
        for (int i = 0; i < 32; ++i) {
            this.flag[i].setSelected(bflags[i]);
            this.flag[i].setEnabled(is_ok && this.settable_flag[i]);
        }
        if (currnode == null) {
            this.setTitle("Flags of <none selected>");
        } else {
            this.setTitle(new StringBuilder(128).append("Flags of ").append(currnode.getFullPath()).append(" (0x").append(Integer.toHexString(iflags)).append(')').toString());
        }
    }
}

