/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import mds.Mds;
import mds.MdsException;
import mds.TreeShr;
import mds.data.CTX;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_a.NidArray;
import mds.data.descriptor_s.Nid;
import mds.jtraverser.TreeManager;
import mds.jtraverser.TreeView;

public abstract class CheckBoxList
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String PROP_FULLPATH = "fullpath";
    protected static final String PROP_NID = "nid";
    protected static final String PROP_OLD = "old";
    protected final JButton discard_b = new JButton("Discard");
    protected final DefaultListModel<JCheckBox> checkboxes = new DefaultListModel();
    protected final JCheckList checklist = new JCheckList(this.checkboxes);
    protected final TreeManager treeman;
    protected final TreeView treeview;
    protected final JButton apply_b = new JButton("Apply");
    protected final JButton update_b = new JButton("Refresh");
    protected int default_nid = -1;

    public CheckBoxList(TreeManager treeman, String title) {
        super(JOptionPane.getRootFrame(), title);
        this.discard_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxList.this.dispose();
            }
        });
        this.update_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxList.this.update();
            }
        });
        this.apply_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckBoxList.this.apply();
            }
        });
        this.treeman = treeman;
        this.treeview = treeman.getCurrentTreeView();
        JScrollPane sp = new JScrollPane();
        sp.getVerticalScrollBar().setUnitIncrement(16);
        sp.setViewportView(this.checklist);
        this.add(sp);
        JPanel buttons = new JPanel(new GridLayout(1, 3));
        buttons.add(this.apply_b);
        buttons.add(this.update_b);
        buttons.add(this.discard_b);
        this.add((Component)buttons, "South");
        this.pack();
    }

    private void addCheckBox(Nid nid, String fullpath) {
        final JCheckBox cb = new JCheckBox(fullpath);
        cb.putClientProperty(PROP_NID, nid);
        cb.putClientProperty(PROP_FULLPATH, fullpath);
        cb.addActionListener(new CheckBoxListener());
        cb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                cb.setText(cb.getToolTipText());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                cb.setText(cb.getName());
            }
        });
        this.checkboxes.addElement(cb);
    }

    protected abstract void apply();

    protected void checkReadOnly() {
        boolean readonly = this.treeview != null && this.treeview.isReadOnly();
        this.checklist.readonly = readonly;
        this.apply_b.setEnabled(!readonly);
    }

    public final void open() {
        this.setLocationRelativeTo(JOptionPane.getRootFrame());
        this.checkReadOnly();
        this.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                CheckBoxList.this.updatelist();
            }
        }).start();
    }

    public void update() {
        this.checkReadOnly();
        if (this.default_nid != this.treeview.getDefault().getNidNumber()) {
            this.updatelist();
        }
    }

    protected abstract void updatelist();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updatelist(byte usage) {
        block28: {
            this.default_nid = this.treeview.getDefault().getNidNumber();
            if (this.treeview == null) {
                this.checklist.removeAll();
            } else {
                try {
                    this.checkboxes.clear();
                    this.checklist.readonly = true;
                    try (TREE tree = this.treeview.getTree();){
                        if (tree.getMds().isLowLatency()) {
                            Mds mds = tree.getMds();
                            synchronized (mds) {
                                int usage_mask = 1 << usage;
                                tree.holdDbid();
                                try {
                                    TreeShr.NodeRefStatus ref = TreeShr.NodeRefStatus.init;
                                    while ((ref = tree.api.treeFindNodeWild(null, "***", usage_mask, ref)).ok()) {
                                        Nid nid = new Nid(ref.data, tree);
                                        try {
                                            this.addCheckBox(nid, nid.getNciFullPath());
                                        }
                                        catch (MdsException e) {
                                            System.err.println(nid.decompile());
                                        }
                                    }
                                }
                                finally {
                                    tree.releaseDbid();
                                }
                                break block28;
                            }
                        }
                        Nid[] nid = tree.findNodesWild(usage);
                        String[] fp = tree.getMds().getStringArray((CTX)tree.ctx, "GETNCI($,'FULLPATH')", new Descriptor[]{new NidArray(nid)});
                        for (int i = 0; i < nid.length; ++i) {
                            this.addCheckBox(nid[i], fp[i]);
                        }
                    }
                }
                catch (MdsException e) {
                    this.checklist.removeAll();
                }
            }
        }
        this.update();
    }

    public final class JCheckList
    extends JList<JCheckBox> {
        private static final long serialVersionUID = 1L;
        private boolean readonly = true;

        public JCheckList(ListModel<JCheckBox> model) {
            this.setCellRenderer(new CellRenderer());
            this.setVisibleRowCount(16);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JCheckList.this.readonly) {
                        return;
                    }
                    int index = JCheckList.this.locationToIndex(e.getPoint());
                    if (index != -1) {
                        if ((e.getModifiers() & 0x10) != 0) {
                            JCheckBox checkbox = (JCheckBox)JCheckList.this.getModel().getElementAt(index);
                            if (checkbox.isEnabled()) {
                                checkbox.setSelected(!checkbox.isSelected());
                            }
                        } else if ((e.getModifiers() & 4) != 0) {
                            JCheckList.this.setRange(index);
                        } else {
                            return;
                        }
                        JCheckList.this.repaint();
                    }
                }
            });
            this.setSelectionMode(0);
            this.setModel(model);
        }

        private void setRange(int index) {
            int stop;
            int start;
            int selected = this.getSelectedIndex();
            if (selected < 0) {
                return;
            }
            boolean state = ((JCheckBox)this.getModel().getElementAt(selected)).isSelected();
            if (index < selected) {
                start = index;
                stop = selected;
            } else {
                start = selected + 1;
                stop = index + 1;
            }
            for (int i = start; i < stop; ++i) {
                ((JCheckBox)this.getModel().getElementAt(i)).setSelected(state);
            }
        }

        protected class CellRenderer
        implements ListCellRenderer<JCheckBox> {
            protected CellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
                value.setBackground(isSelected ? JCheckList.this.getSelectionBackground() : JCheckList.this.getBackground());
                value.setFont(JCheckList.this.getFont());
                value.setFocusPainted(false);
                value.setBorderPainted(true);
                value.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : new EmptyBorder(1, 1, 1, 1));
                return value;
            }
        }
    }

    public final class CheckBoxListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ce) {
        }
    }
}

