/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser.dialogs;

import java.awt.Color;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import mds.MdsException;
import mds.data.CTX;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_a.Int32Array;
import mds.data.descriptor_r.Action;
import mds.data.descriptor_s.Nid;
import mds.jtraverser.Node;
import mds.jtraverser.TreeManager;
import mds.jtraverser.dialogs.CheckBoxList;

public class ActionList
extends CheckBoxList {
    private static final long serialVersionUID = 1L;

    public ActionList(TreeManager treeman) {
        super(treeman, "Action Nodes in Tree");
    }

    @Override
    protected void apply() {
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox cb = (JCheckBox)this.checkboxes.getElementAt(i);
            if (cb.isSelected() == ((Boolean)cb.getClientProperty("old")).booleanValue()) continue;
            Nid nid = (Nid)cb.getClientProperty("nid");
            DefaultMutableTreeNode treenode = this.treeview.findPath((String)cb.getClientProperty("fullpath"));
            try {
                nid.setOn(cb.isSelected());
                if (treenode == null) continue;
                ((Node)treenode.getUserObject()).setOnUnchecked();
                continue;
            }
            catch (MdsException me) {
                MdsException.stderr((String)"ActionList.apply", (Exception)((Object)me));
            }
        }
        this.treeview.reportChange();
        this.update();
    }

    @Override
    public final void update() {
        super.update();
        if (this.checkboxes.size() > 0) {
            int[] nid = new int[this.checkboxes.size()];
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                nid[i] = ((Nid)((JCheckBox)this.checkboxes.getElementAt(i)).getClientProperty("nid")).getNidNumber();
            }
            try (TREE tree = this.treeview.getTree();){
                byte[] isoff = tree.getMds().getByteArray((CTX)this.treeview.getTree().ctx, "_n=$;OR(GETNCI(_n,'PARENT_STATE'),GETNCI(_n,'STATE'))", new Descriptor[]{new Int32Array(nid)});
                int[] status = tree.getMds().getIntegerArray((CTX)this.treeview.getTree().ctx, "GETNCI($,'STATUS')", new Descriptor[]{new Int32Array(nid)});
                for (int i = 0; i < this.checkboxes.size(); ++i) {
                    JCheckBox cb = (JCheckBox)this.checkboxes.getElementAt(i);
                    cb.setSelected(isoff[i] == 0);
                    cb.putClientProperty("old", isoff[i] == 0);
                    if (this.treeview.isModel()) continue;
                    cb.setToolTipText(Action.getStatusMsg((int)status[i]));
                    cb.setForeground((status[i] & 1) == 0 ? Color.RED : Color.BLACK);
                }
            }
            catch (MdsException e) {
                MdsException.stderr((String)"ActionList.update", (Exception)((Object)e));
            }
        }
        this.repaint();
    }

    @Override
    protected final void updatelist() {
        this.updatelist((byte)2);
    }
}

