/*
 * Decompiled with CFR 0.152.
 */
package mds.jtraverser;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mds.Mds;
import mds.MdsException;
import mds.data.TREE;
import mds.data.descriptor.Descriptor;
import mds.data.descriptor_r.Conglom;
import mds.data.descriptor_s.NODE;
import mds.data.descriptor_s.Nid;
import mds.jtraverser.DataChangeEvent;
import mds.jtraverser.DataChangeListener;
import mds.jtraverser.MdsView;
import mds.jtraverser.Node;
import mds.jtraverser.TreeManager;

public final class TreeView
extends JTree
implements TreeSelectionListener,
DataChangeListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    Vector<TreeManager.Job> change_report_listeners = new Vector();
    private int copy_format;
    private Node curr_node;
    private final TREE tree;
    private String lastName;
    private DefaultMutableTreeNode top;

    public static Node addNode(byte usage, String name, Node toNode) {
        Node new_node;
        if (name == null || name.length() == 0 || name.length() > 12) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Name length must range between 1 and 12 characters", "Error adding Node", 2);
            return null;
        }
        try {
            new_node = toNode.addNode(name, usage);
            DefaultMutableTreeNode new_tree_node = new DefaultMutableTreeNode(new_node);
            new_node.setTreeNode(new_tree_node);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage(), "Error adding Node", 2);
            return null;
        }
        return new_node;
    }

    public static final String decompile(Descriptor<?> data) {
        return data.toString();
    }

    public TreeView(Mds mds, String expt, int shot, TREE.MODE mode) throws MdsException {
        this(new TREE(mds, expt, shot), mode);
    }

    public TreeView(MdsView mdsview, String expt, int shot, TREE.MODE mode) throws MdsException {
        this(mdsview.getMds(), expt, shot, mode);
        this.addMouseListener(mdsview.treeman.getContextMenu());
    }

    public TreeView(TREE tree, TREE.MODE mode) throws MdsException {
        this.tree = tree;
        try {
            this.tree.open(mode);
        }
        catch (MdsException me) {
            if (mode != TREE.EDITABLE || me.getStatus() != 265392146) {
                throw me;
            }
            int n = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), String.format("Tree %s cannot be opened in edit mode. Create new instead?", tree.expt), "Editing Tree", 0);
            if (n != 0) {
                throw me;
            }
            this.tree.open(TREE.NEW);
        }
        this.setTransferHandler(new FromTransferHandler());
        this.setDragEnabled(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setEditable(this.tree.is_editable());
        this.addTreeSelectionListener(this);
        this.addTreeWillExpandListener(this);
        this.getSelectionModel().setSelectionMode(1);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u0003') {
                    TreeView.this.getCurrentNode().copyToClipboard();
                    TreeView.this.getCurrentNode().copy();
                } else if (e.getKeyChar() == '\u0018') {
                    if (TreeView.this.isEditable()) {
                        TreeView.this.getCurrentNode().cut();
                    } else {
                        TreeView.this.getCurrentNode().copy();
                    }
                } else if (e.getKeyChar() == '\u0016') {
                    TreeView.this.getCurrentNode().paste();
                } else if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                    TreeView.this.getCurrentNode().delete();
                } else if (e.getKeyChar() == ' ' && e.isControlDown()) {
                    try {
                        TreeView.this.getCurrentNode().setDefault();
                    }
                    catch (MdsException exc) {
                        MdsException.stderr((String)"SetDefault", (Exception)((Object)exc));
                    }
                }
                TreeView.this.dispatchChangeReport();
            }
        });
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Node top_node = new Node(this, this.tree.getTop());
        this.top = new DefaultMutableTreeNode(top_node);
        top_node.setTreeNode(this.top);
        this.expandPath(new TreePath(this.top.getPath()));
        model.setRoot(this.top);
        this.setCellRenderer(new MDSCellRenderer());
        this.setCurrentNode(0);
        this.expandRow(0);
        try {
            this.updateDefault();
        }
        catch (MdsException mdsException) {
            // empty catch block
        }
    }

    public void addChangeReportListener(TreeManager.Job job) {
        this.change_report_listeners.add(job);
    }

    public Node addNode(byte usage, String name) {
        return TreeView.addNode(usage, name, this.getCurrentNode());
    }

    public void addNodeToParent(DefaultMutableTreeNode treenode, DefaultMutableTreeNode toTreeNode) {
        int num_children = toTreeNode.getChildCount();
        int i = 0;
        if (num_children > 0) {
            String curr_name;
            String name = Node.getNode(treenode).getName();
            for (i = 0; i < num_children && name.compareTo(curr_name = ((Node)((DefaultMutableTreeNode)toTreeNode.getChildAt(i)).getUserObject()).getName()) >= 0; ++i) {
            }
        }
        DefaultTreeModel tree_model = (DefaultTreeModel)this.getModel();
        tree_model.insertNodeInto(treenode, toTreeNode, i);
        this.expandPath(new TreePath(treenode.getPath()));
        this.treeDidChange();
    }

    private final DefaultMutableTreeNode addTreeNode(DefaultMutableTreeNode treenode, Node node) {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(node);
        node.setTreeNode(new_node);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(new_node, treenode, treenode.getChildCount());
        return new_node;
    }

    public final TreeView close(boolean quit) {
        try {
            if (quit) {
                this.tree.quitTree();
            } else {
                this.tree.close();
            }
        }
        catch (Exception e) {
            boolean leditable = false;
            String name = null;
            leditable = this.tree.is_editable();
            name = this.tree.expt;
            if (leditable && !quit) {
                int n = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "Tree " + name + " open in edit mode has been changed: Write it before closing?", "Closing Tree ", 0);
                if (n == 0) {
                    try {
                        this.tree.writeTree();
                        this.tree.close();
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Error closing tree", exc.getMessage(), 2);
                    }
                } else {
                    try {
                        this.tree.quitTree();
                    }
                    catch (Exception exce) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Error quitting tree", exce.getMessage(), 2);
                    }
                }
            }
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Error closing tree", e.getMessage(), 2);
        }
        return this;
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        this.dispatchChangeReport();
    }

    public final void deleteNode() {
        this.deleteNode(this.getCurrentNode());
        this.setCurrentNode(0);
    }

    public void deleteNode(Node delNode) {
        if (delNode == null) {
            return;
        }
        Node del_node = delNode;
        int n_children = del_node.deleteInitialize();
        if (n_children < 0) {
            return;
        }
        String msg = "You are about to delete node " + del_node.getName().trim();
        msg = n_children > 0 ? msg + " which has " + n_children + " descendents.\n Please confirm" : msg + "\n Please confirm";
        int n = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), msg, "Delete node(s)", 0);
        if (n == 0) {
            if (!del_node.deleteExecute()) {
                return;
            }
            this.setSelectionRow(0);
            DefaultTreeModel tree_model = (DefaultTreeModel)this.getModel();
            tree_model.removeNodeFromParent(delNode.getTreeNode());
        }
    }

    public void dispatchChangeReport() {
        for (TreeManager.Job job : this.change_report_listeners) {
            job.program();
        }
    }

    public final int expandPath(NODE<?> node) {
        int row = 0;
        try {
            String[] pathstr = node.toFullPath().toString().split("::", 2)[1].split("[.:]");
            TreePath treepath = null;
            for (String part : pathstr) {
                this.expandRow(row);
                treepath = this.getNextMatch(part, row, Position.Bias.Forward);
                row = this.getRowForPath(treepath);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            MdsException.stderr((String)"Open Link", (Exception)exc);
        }
        this.scrollRowToVisible(row);
        this.setSelectionRow(row);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void expandPath(TreePath path) {
        DefaultMutableTreeNode tree_node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Node currnode = Node.getNode(tree_node);
        DefaultMutableTreeNode dummy = currnode.dummy;
        if (dummy != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = dummy;
            synchronized (defaultMutableTreeNode) {
                if (currnode.dummy == dummy) {
                    Node[] members;
                    try {
                        currnode.expand();
                    }
                    catch (Exception exc) {
                        MdsException.stderr((String)"Error expanding tree", (Exception)exc);
                        exc.printStackTrace();
                    }
                    Node[] children = currnode.getChildren();
                    for (Node member : members = currnode.getMembers()) {
                        this.addTreeNode(tree_node, member);
                    }
                    for (Node child : children) {
                        this.addTreeNode(tree_node, child);
                    }
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(currnode.dummy);
                    currnode.dummy = null;
                    this.treeDidChange();
                }
            }
        }
        super.expandPath(path);
    }

    public final DefaultMutableTreeNode findNid(Nid nid) {
        try {
            return this.findPath(nid.getNciFullPath());
        }
        catch (MdsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final DefaultMutableTreeNode findPath(String path) {
        String[] treepath = path.split("::", 2);
        return this.findPath(treepath[treepath.length - 1].split("[\\.:]"));
    }

    public final DefaultMutableTreeNode findPath(String[] path) {
        if (path == null || path.length == 0) {
            return this.top;
        }
        if (path[0].equalsIgnoreCase("TOP")) {
            path = Arrays.copyOfRange(path, 1, path.length);
        }
        return this.findSubPath(path, this.top);
    }

    private final DefaultMutableTreeNode findSubPath(String[] path, DefaultMutableTreeNode root) {
        if (path == null || path.length == 0) {
            return root;
        }
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            Node node = (Node)child.getUserObject();
            if (!node.getName().equalsIgnoreCase(path[0])) continue;
            return this.findSubPath(Arrays.copyOfRange(path, 1, path.length), child);
        }
        return null;
    }

    public final Node getCurrentNode() {
        return this.curr_node;
    }

    public final DefaultMutableTreeNode getCurrTreeNode() {
        Node node = this.getCurrentNode();
        if (node == null) {
            return null;
        }
        return node.getTreeNode();
    }

    public final Nid getDefault() {
        return this.tree.getDefaultC();
    }

    public final String getExpt() {
        return this.tree.expt;
    }

    public String getLabel() {
        String mode;
        String string = this.tree.is_editable() ? "!" : (mode = this.tree.is_readonly() ? "?" : "");
        if (this.tree.shot == -1) {
            return String.format("%s_model%s", this.tree.expt.toLowerCase(), mode);
        }
        return String.format("%s_%03d%s", this.tree.expt.toLowerCase(), 0xFFFFFFFFL & (long)this.tree.shot, mode);
    }

    public final Mds getMds() {
        return this.tree.getMds();
    }

    public final TREE.MODE getMode() {
        return this.tree.getMode();
    }

    public final int getShot() {
        return this.tree.shot;
    }

    public final TREE getTree() {
        return this.tree;
    }

    public final boolean isModel() {
        return this.tree.shot == -1;
    }

    public final boolean isReadOnly() {
        return this.tree.is_readonly();
    }

    public void pasteSubtree(Node fromNode, Node toNode, boolean isMember) {
        DefaultMutableTreeNode savedTreeNode;
        block11: {
            savedTreeNode = this.getCurrTreeNode();
            try {
                fromNode.expand();
                String[] usedNames = new String[toNode.getChildren().length + toNode.getMembers().length];
                int idx = 0;
                for (Node child : toNode.getChildren()) {
                    usedNames[idx++] = child.getName();
                }
                for (Node member : toNode.getMembers()) {
                    usedNames[idx++] = member.getName();
                }
                if (fromNode.getUsage() == 3) {
                    Conglom conglom = (Conglom)fromNode.getRecord();
                    Node newNode = toNode.addDevice((isMember ? ":" : ".") + Node.getUniqueName(fromNode.getName(), usedNames), conglom.getModel().toString());
                    newNode.expand();
                    Node.copySubtreeContent(fromNode, newNode);
                    break block11;
                }
                Node newNode = TreeView.addNode(fromNode.getUsage(), (isMember ? ":" : ".") + Node.getUniqueName(fromNode.getName(), usedNames), toNode);
                if (newNode == null) {
                    return;
                }
                newNode.expand();
                try {
                    Descriptor<?> data = fromNode.getRecord();
                    if (data != null && fromNode.getUsage() != 2) {
                        newNode.setData(data);
                    }
                }
                catch (MdsException mdsException) {
                    // empty catch block
                }
                for (Node child : fromNode.getChildren()) {
                    this.pasteSubtree(child, newNode, false);
                }
                for (Node member : fromNode.getMembers()) {
                    this.pasteSubtree(member, newNode, true);
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, "" + exc, "Error copying subtree", 2);
            }
        }
        this.setCurrentNode(savedTreeNode);
    }

    public void removeChangeReportListener(TreeManager.Job job) {
        this.change_report_listeners.remove(job);
    }

    public final synchronized void reportChange() {
        this.treeDidChange();
        this.updateUI();
        this.dispatchChangeReport();
    }

    public void reset() {
        this.top.removeAllChildren();
        try {
            this.tree.open();
        }
        catch (MdsException e) {
            e.printStackTrace();
        }
        Node topnode = (Node)this.top.getUserObject();
        topnode.update();
        this.setCurrentNode(-1);
        topnode.setTreeNode(this.top);
        this.expandPath(new TreePath(this.top.getPath()));
        this.setCurrentNode(0);
        try {
            topnode.setDefault();
        }
        catch (MdsException mdsException) {
            // empty catch block
        }
        this.reportChange();
    }

    public void set_copy_format(int format) {
        this.copy_format = format;
    }

    public final void setCurrentNode(DefaultMutableTreeNode treenode) {
        Node new_curr_node = Node.getNode(treenode);
        if (new_curr_node == null) {
            return;
        }
        this.setCurrentNode(new_curr_node);
    }

    private final void setCurrentNode(int row) {
        this.setSelectionRow(row);
        DefaultMutableTreeNode DMN = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (DMN == null) {
            return;
        }
        this.setCurrentNode(DMN);
    }

    public final void setCurrentNode(Node curr_node) {
        this.setSelectionPath(new TreePath(curr_node.getTreeNode().getPath()));
        this.curr_node = curr_node;
    }

    @Override
    public final String toString() {
        return this.tree.toString();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(final TreeExpansionEvent e) throws ExpandVetoException {
        Thread thread = new Thread("expand"){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public final void run() {
                TreeView.this.expandPath(e.getPath());
            }
        };
        thread.start();
    }

    public final void updateDefault() throws MdsException {
        this.tree.getDefaultNid();
        this.reportChange();
    }

    @Override
    public final void valueChanged(TreeSelectionEvent e) {
        Node currnode = Node.getNode((DefaultMutableTreeNode)e.getPath().getLastPathComponent());
        this.setCurrentNode(currnode);
        this.treeDidChange();
    }

    public final void writeTree() {
        try {
            this.tree.writeTree();
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Error writing tree", exc.getMessage(), 2);
        }
    }

    private final class MDSCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private MDSCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean is_selected, boolean expanded, boolean has_focus, int row, boolean leaf) {
            Node node;
            Object usrObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (usrObj instanceof Component) {
                return (Component)usrObj;
            }
            if (usrObj instanceof String) {
                node = TreeView.this.getCurrentNode();
                if (node.getTreeNode() == value) {
                    String newName = ((String)usrObj).trim().toUpperCase();
                    if (TreeView.this.lastName == null || !TreeView.this.lastName.equals(newName)) {
                        TreeView.this.lastName = newName;
                        node.rename(newName);
                    }
                    node.getTreeNode().setUserObject(node);
                }
            } else {
                node = (Node)usrObj;
            }
            return node.getIcon(is_selected);
        }
    }

    private static final class FromTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private FromTransferHandler() {
        }

        @Override
        public final Transferable createTransferable(JComponent comp) {
            if (!(comp instanceof TreeView)) {
                return null;
            }
            TreeView tree = (TreeView)comp;
            Node node = tree.getCurrentNode();
            switch (tree.copy_format) {
                case 0: {
                    return new StringSelection(node.getFullPath());
                }
                case 1: {
                    return new StringSelection(node.getPath());
                }
                case 2: {
                    return new StringSelection(node.getMinPath());
                }
                case 3: {
                    return new StringSelection(node.getName());
                }
            }
            return null;
        }

        @Override
        public final int getSourceActions(JComponent comp) {
            return 3;
        }
    }
}

