/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class Timestamp {
    private static volatile Timestamp singleton;
    private static final String defaultDateFormat = "yyyy-MM-dd HH:mm:ss X";
    private static final Map<String, Timestamp> map;
    private SimpleDateFormat format;

    public static Timestamp getDefaultInstance() {
        return Timestamp.getDefaultInstance(defaultDateFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getDefaultInstance(String format) {
        if (map.containsKey(format)) {
            return map.get(format);
        }
        Map<String, Timestamp> map = Timestamp.map;
        synchronized (map) {
            if (!Timestamp.map.containsKey(format)) {
                Timestamp timestamp = new Timestamp(format);
                Timestamp.map.put(format, timestamp);
                return timestamp;
            }
            return Timestamp.map.get(format);
        }
    }

    public Timestamp(String format) {
        this.format = new SimpleDateFormat(format);
    }

    public final void setDateFormat(String format) {
        TimeZone zone = this.format.getTimeZone();
        this.format = new SimpleDateFormat(format);
        this.format.setTimeZone(zone);
    }

    public final void setTimeZone(TimeZone zone) {
        this.format.setTimeZone(zone);
    }

    public String getTimestamp() {
        return this.getTimestamp(null);
    }

    public String getTimestamp(Date date) {
        if (date == null) {
            date = new Date();
        }
        return this.format.format(date);
    }

    static {
        map = new HashMap<String, Timestamp>(4);
    }
}

