/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.util.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.exceptions.ConsumableException;
import org.mazarineblue.keyworddriven.exceptions.ToFewParametersException;
import org.mazarineblue.keyworddriven.util.methods.ConvertingClassesFacade;
import org.mazarineblue.keyworddriven.util.methods.ConvertingObjectsFacade;

public class MethodWrapper {
    private final Method method;
    private final Parameters parameters;

    public MethodWrapper(Method method, String path) {
        this.method = method;
        this.parameters = method.getAnnotation(Parameters.class);
    }

    public void check(Object[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters required");
        }
        this.checkParamtersSize(parameters);
    }

    private void checkParamtersSize(Object[] parameters) {
        int min = this.parameters == null ? 0 : this.parameters.min();
        int max = this.parameters == null ? parameters.length : this.parameters.max();
        int found = this.method.getParameterTypes().length;
        if (parameters.length < min || max < found) {
            throw new ToFewParametersException(min, max, found);
        }
    }

    private void checkParameterTypes(Object[] parameters) {
        Class<?>[] expectedTypes = this.method.getParameterTypes();
        Object[] arr = ConvertingObjectsFacade.getInstance().convert(parameters, expectedTypes);
        arr = this.convert(arr, expectedTypes);
        for (int i = 0; i < arr.length; ++i) {
            if (expectedTypes[i].equals(arr[i].getClass())) continue;
            throw new ConsumableException("Invalid parameter at index:" + i);
        }
    }

    private Object[] convert(Object[] input, Class<?>[] expectedTypes) {
        if (expectedTypes.length == 0) {
            return new Object[0];
        }
        Object[] output = new Object[expectedTypes.length];
        int last = expectedTypes.length - 1;
        for (int i = 0; i < last; ++i) {
            output[i] = input[i];
        }
        output[last] = expectedTypes[last].equals(String[].class) ? this.convertToStrings(this.getRemainer(input)) : (expectedTypes[last].equals(Object[].class) ? this.getRemainer(input) : input[last]);
        return output;
    }

    private Object[] getRemainer(Object[] parameters) {
        Class<?>[] expectedTypes = this.method.getParameterTypes();
        int m = parameters.length - expectedTypes.length + 1;
        int offset = parameters.length - m;
        Object[] arr = new Object[m];
        for (int i = 0; i < m; ++i) {
            arr[i] = parameters[i + offset];
        }
        return arr;
    }

    private String[] convertToStrings(Object[] input) {
        String[] output = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (!(input[i] instanceof String)) {
                return null;
            }
            output[i] = (String)input[i];
        }
        return output;
    }

    public Object invoke(Object obj, Object[] parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        parameters = this.clipParameters(parameters);
        Class<?>[] expectedTypes = this.getParameterTypes();
        Object[] arr = ConvertingObjectsFacade.getInstance().convert(parameters, expectedTypes);
        arr = this.convert(arr, expectedTypes);
        return this.method.invoke(obj, arr);
    }

    private Object[] clipParameters(Object[] parameters) {
        if (this.parameters != null && parameters.length > this.parameters.max()) {
            parameters = Arrays.copyOf(parameters, this.parameters.max());
        }
        return parameters;
    }

    private Class<?>[] getParameterTypes() {
        Class<?>[] expectedTypes = this.method.getParameterTypes();
        expectedTypes = ConvertingClassesFacade.getInstance().convert(expectedTypes);
        return expectedTypes;
    }
}

