/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.util.methods;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ConvertingObjectsFacade {
    private static ConvertingObjectsFacade singleton = null;
    private final Map<Profile, ConvertingMethod> map = new HashMap<Profile, ConvertingMethod>(15);

    static ConvertingObjectsFacade getInstance() {
        if (singleton == null) {
            singleton = new ConvertingObjectsFacade();
        }
        return singleton;
    }

    ConvertingObjectsFacade() {
        this.addStringConversions();
        this.addDoubleConversions();
        this.addFloatConversions();
    }

    private void addStringConversions() {
        this.map.put(new Profile(String.class, Byte.class), input -> Byte.parseByte((String)input));
        this.map.put(new Profile(String.class, Integer.class), input -> Integer.parseInt((String)input));
        this.map.put(new Profile(String.class, Long.class), input -> Long.parseLong((String)input));
        this.map.put(new Profile(String.class, Float.class), input -> Float.valueOf(Float.parseFloat((String)input)));
        this.map.put(new Profile(String.class, Double.class), input -> Double.parseDouble((String)input));
    }

    private void addDoubleConversions() {
        this.map.put(new Profile(Double.class, Byte.class), input -> (byte)Math.round((Double)input));
        this.map.put(new Profile(Double.class, Integer.class), input -> (int)Math.round((Double)input));
        this.map.put(new Profile(Double.class, Long.class), input -> Math.round((Double)input));
    }

    private void addFloatConversions() {
        this.map.put(new Profile(Float.class, Byte.class), input -> (byte)Math.round(((Float)input).floatValue()));
        this.map.put(new Profile(Float.class, Integer.class), input -> Math.round(((Float)input).floatValue()));
        this.map.put(new Profile(Float.class, Long.class), input -> Math.round(((Float)input).floatValue()));
    }

    Object[] convert(Object[] input, Class<?>[] expectedType) {
        int i;
        int capacity = expectedType.length > input.length ? expectedType.length : input.length;
        Object[] arr = new Object[capacity];
        int n = expectedType.length < input.length ? expectedType.length : input.length;
        for (i = 0; i < n; ++i) {
            arr[i] = this.convert(input[i], expectedType[i]);
        }
        for (i = n; i < input.length; ++i) {
            arr[i] = input[i];
        }
        for (i = n; i < expectedType.length; ++i) {
            arr[i] = null;
        }
        return arr;
    }

    Object convert(Object input, Class<?> expectedType) {
        Class<?> clazz = input.getClass();
        Profile profile = new Profile(clazz, expectedType);
        ConvertingMethod convertMethod = this.map.get(profile);
        try {
            if (convertMethod != null) {
                return convertMethod.convert(input);
            }
            if (expectedType == String.class && clazz != String.class) {
                return input.toString();
            }
            return input;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private static interface ConvertingMethod {
        public Object convert(Object var1);
    }

    private class Profile {
        private Class<?> inputType;
        private Class<?> outputType;

        private Profile(Class<? extends Object> inputType, Class<?> outputType) {
            this.inputType = inputType;
            this.outputType = outputType;
        }

        public String toString() {
            return "(" + this.inputType + ", " + this.outputType + ')';
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + Objects.hashCode(this.inputType);
            hash = 59 * hash + Objects.hashCode(this.outputType);
            hash = 59 * hash + Objects.hashCode(this.getClass());
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Profile other = (Profile)obj;
            if (!Objects.equals(this.inputType, other.inputType)) {
                return false;
            }
            return Objects.equals(this.outputType, other.outputType);
        }
    }
}

