/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.util;

import org.mazarineblue.events.instructions.ExecuteInstructionLineEvent;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.librarymanager.Instruction;

public abstract class InstructionInvoker {
    public void invoke(InstructionLineEvent event) {
        if (this.skipInvokation(event)) {
            return;
        }
        Instruction instruction = this.getInstruction(event);
        this.doInvoke(instruction, event);
    }

    protected boolean skipInvokation(InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        return line.isEmpty();
    }

    protected abstract Instruction getInstruction(InstructionLineEvent var1);

    private void doInvoke(Instruction instruction, InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        Object[] parameters = line.getParameters();
        instruction.validate(parameters);
        if (event instanceof ExecuteInstructionLineEvent) {
            instruction.invoke(parameters);
        }
        event.setConsumed();
    }
}

