/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.proceduremanager;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.ObjectArraySource;
import org.mazarineblue.keyworddriven.DocumentMediator;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.SheetFactory;
import org.mazarineblue.keyworddriven.feeds.CollectionFeed;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.proceduremanager.Procedure;

public class ProcedureManager {
    private final Deque<Map<String, Procedure>> stack = new ArrayDeque<Map<String, Procedure>>();

    public ProcedureManager() {
        this.stack.push(new HashMap(4));
    }

    public Map<String, Procedure> peekScope() {
        return this.stack.peek();
    }

    public void pushScope() {
        this.stack.push(new HashMap<String, Procedure>(this.stack.peek()));
    }

    public void pushScope(Map<String, Procedure> scope) {
        this.stack.push(scope);
    }

    public Map<String, Procedure> popScope() {
        return this.stack.pop();
    }

    public boolean contains(InstructionLine line) {
        if (!line.getNamespace().isEmpty()) {
            return false;
        }
        return this.stack.peek().containsKey(line.getKeyword());
    }

    public final Procedure register(String name, Procedure procedure) {
        return this.stack.peek().put(name, procedure);
    }

    public void unregister(String name) {
        this.stack.peek().remove(name);
    }

    public void execute(InstructionLine line, DataSource source, InterpreterContext context) {
        String keyword = line.getKeyword();
        Object[] parameters = line.getParameters();
        this.execute(keyword, parameters, context);
    }

    public void execute(String name, Object[] parameters, InterpreterContext context) {
        DocumentMediator documentMediator = context.documentMediator();
        SheetFactory sheetFactory = context.sheetFactory();
        Log log = context.log();
        Procedure procedure = this.stack.peek().get(name);
        CollectionFeed feed = new CollectionFeed(procedure.getInstructions());
        ObjectArraySource source = procedure.getStackSource("ProcedureStackSource", parameters);
        context.blackboard().pushSource(source);
        context.executor().executeNested(feed, log, context);
        context.blackboard().popSource();
    }
}

