/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs.visitors;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.mazarineblue.keyworddriven.logs.dom.CollectionElement;
import org.mazarineblue.keyworddriven.logs.dom.Component;
import org.mazarineblue.keyworddriven.logs.dom.ExceptionResult;
import org.mazarineblue.keyworddriven.logs.dom.LineElement;
import org.mazarineblue.keyworddriven.logs.dom.MessageResult;
import org.mazarineblue.keyworddriven.logs.visitors.LogVisitor;
import org.mazarineblue.util.Timestamp;

public class XmlLogVisitor
implements LogVisitor {
    private final OutputStream output;
    private boolean even = false;
    private final Timestamp timestamp = Timestamp.getDefaultInstance();

    public XmlLogVisitor(OutputStream output) {
        this.output = output;
    }

    @Override
    public void startCollection(CollectionElement collection) throws IOException {
        this.write("<collection status='%s' startDate='%s' endDate='%s'>", this.getStatus(collection), this.timestamp.getTimestamp(collection.getStartDate()), this.timestamp.getTimestamp(collection.getEndDate()));
    }

    @Override
    public void endCollection(CollectionElement collection) throws IOException {
        this.write("</collection>", new Object[0]);
    }

    @Override
    public void openLine(LineElement line) throws IOException {
        this.write("<line processingType='%s' status='%s' path='%s' even='%s'>", line.getProcessingType().name().toLowerCase(), this.getStatus(line), line.getPath(), this.even ? "even" : "uneven");
        this.writeEscape("<lineIdentifier>%s</lineIdentifier>", line.getLineIdentifier());
        this.write("<startDate>%s</startDate>", this.timestamp.getTimestamp(line.getStartDate()));
        this.write("<endDate>%s</endDate>", this.timestamp.getTimestamp(line.getEndDate()));
        this.write("<elapsedTime>%s</elapsedTime>", line.getElapsedTime());
        this.writeEscape("<namespace>%s</namespace>", line.getNamespace());
        this.writeEscape("<keyword>%s</keyword>", line.getKeyword());
        this.writeEscape("<parameters>%s</parameters>", line.getParameters());
        this.even = !this.even;
    }

    @Override
    public void endLine(LineElement line) throws IOException {
        this.write("</line>", new Object[0]);
    }

    @Override
    public void message(MessageResult msg) throws IOException {
        String status = this.getStatus(msg);
        String message = msg.getMessage();
        this.write("<message status='%s' even='%s'>", status, this.even ? "even" : "uneven");
        this.write("<date>%s</date>", this.timestamp.getTimestamp(msg.getStartDate()));
        this.writeEscape("<value>%s</value>", message);
        this.write("</message>", new Object[0]);
        this.even = !this.even;
    }

    @Override
    public void exception(ExceptionResult ex) throws IOException {
        String status = this.getStatus(ex);
        String message = ex.getMessage();
        this.write("<exception status='%s' even='%s'>", status, this.even ? "even" : "uneven");
        this.write("<date>%s</date>", this.timestamp.getTimestamp(ex.getStartDate()));
        this.writeEscape("<value>%s</value>", message);
        this.writeStackTrace(ex);
        this.write("</exception>", new Object[0]);
        this.even = !this.even;
    }

    private void writeStackTrace(ExceptionResult ex) throws IOException {
        this.write("<stacktrace><![CDATA[", new Object[0]);
        ex.writeStackTrace(this.output);
        this.write("]]></stacktrace>", new Object[0]);
    }

    private void writeEscape(String format, Object ... args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = StringEscapeUtils.escapeXml((String)((String)args[i]));
        }
        this.write(format, args);
    }

    private void write(String format, Object ... args) throws IOException {
        String str = String.format(format, args);
        this.output.write(str.getBytes());
    }

    private String getStatus(Component leaf) {
        return leaf.getStatus().name().toLowerCase();
    }
}

