/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs.dom;

import java.io.IOException;
import java.util.Date;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Processor;
import org.mazarineblue.keyworddriven.logs.dom.Composite;
import org.mazarineblue.keyworddriven.logs.visitors.LogVisitor;

public class LineElement
extends Composite {
    private final InstructionLine line;
    private final Processor.ProcessingType processingType;
    private Object[] actualParameter;

    public LineElement(InstructionLine line, Date startDate, Processor.ProcessingType processingType) {
        super(startDate);
        this.line = line;
        this.processingType = processingType;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getStatus()) + " : " + this.line;
    }

    public Processor.ProcessingType getProcessingType() {
        return this.processingType;
    }

    public InstructionLine getInstructionLine() {
        return this.line;
    }

    public String getLineIdentifier() {
        return this.line.getLineIdentifier();
    }

    public String getPath() {
        return this.line.getPath();
    }

    public String getNamespace() {
        return this.line.getNamespace();
    }

    public String getKeyword() {
        return this.line.getKeyword();
    }

    public String getParameters() {
        Object[] parameter = this.line.getParameters();
        if (parameter.length == 0) {
            return "";
        }
        String str = "(" + this.getParameter(0, parameter);
        for (int i = 1; i < parameter.length; ++i) {
            str = str + ", " + this.getParameter(i, parameter);
        }
        return str + ")";
    }

    private String getParameter(int index, Object[] parameter) {
        String str = parameter[index].toString();
        if (this.skipActualParameters(index, parameter)) {
            return str;
        }
        str = str + " => '" + this.actualParameter[index] + "'";
        return str;
    }

    private boolean skipActualParameters(int index, Object[] parameter) {
        if (this.actualParameter == null || index >= this.actualParameter.length) {
            return true;
        }
        if (this.actualParameter[index] == null || this.actualParameter[index].equals("")) {
            return true;
        }
        return parameter[index].equals(this.actualParameter[index]);
    }

    public void setActualParameters(Object[] actualParameter) {
        Object[] parameter = this.line.getParameters();
        this.actualParameter = actualParameter;
    }

    @Override
    public void accept(LogVisitor visitor) throws IOException {
        visitor.openLine(this);
        super.accept(visitor);
        visitor.endLine(this);
    }
}

