/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mazarineblue.keyworddriven.logs.dom.Component;
import org.mazarineblue.keyworddriven.logs.dom.ExceptionResult;
import org.mazarineblue.keyworddriven.logs.dom.MessageResult;
import org.mazarineblue.keyworddriven.logs.dom.Status;
import org.mazarineblue.keyworddriven.logs.dom.StatusLeaf;
import org.mazarineblue.keyworddriven.logs.visitors.LogVisitor;

public abstract class Composite
extends Component {
    private final List<Component> childeren = new ArrayList<Component>(0);

    public Composite(Date startDate) {
        super(startDate);
    }

    public StatusLeaf add(Status status, String message) {
        MessageResult leaf = new MessageResult(status, message);
        this.add(leaf);
        return leaf;
    }

    public StatusLeaf add(Status status, Throwable ex) {
        ExceptionResult leaf = new ExceptionResult(status, ex);
        this.add(leaf);
        return leaf;
    }

    public final void add(Component e) {
        this.childeren.add(e);
    }

    public String toString() {
        return (Object)((Object)this.getStatus()) + " : size=" + this.childeren.size();
    }

    @Override
    public Status getStatus() {
        Status status = Status.PASS;
        for (Component child : this.childeren) {
            Status s = child.getStatus();
            switch (s) {
                case INFO: {
                    if (!status.equals((Object)Status.PASS)) break;
                    status = s;
                    break;
                }
                case WARNING: {
                    status = s;
                    break;
                }
                case ERROR: {
                    return s;
                }
            }
        }
        return status;
    }

    @Override
    public void accept(LogVisitor visitor) throws IOException {
        for (Component e : this.childeren) {
            e.accept(visitor);
        }
    }
}

