/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs.dom;

import java.io.IOException;
import java.util.Date;
import org.mazarineblue.keyworddriven.logs.dom.Status;
import org.mazarineblue.keyworddriven.logs.visitors.LogVisitor;

public abstract class Component {
    private final Date stateDate;
    private Date endDate;

    public Component(Date startDate) {
        this.stateDate = this.endDate = startDate;
    }

    public void done(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.stateDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public long getElapsedTime() {
        return this.endDate.getTime() - this.stateDate.getTime();
    }

    public abstract Status getStatus();

    public abstract void accept(LogVisitor var1) throws IOException;
}

