/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Processor;
import org.mazarineblue.keyworddriven.exceptions.ConsumableException;
import org.mazarineblue.keyworddriven.logs.Log;

public class StreamLog
implements Log {
    private final PrintStream output;
    private String prefix = "";

    public StreamLog(OutputStream output) {
        this.output = new PrintStream(output);
    }

    public StreamLog(PrintStream output) {
        this.output = output;
    }

    @Override
    public void next(InstructionLine line, DataSource source, InterpreterContext context, Processor.ProcessingType processingType) throws IllegalSourceStateException {
        String namespace = line.getNamespace();
        String keyword = line.getKeyword();
        Object[] parameters = line.getParameters();
        this.output.print(this.prefix);
        this.output.print("Instruction: ");
        this.output.print(namespace);
        this.output.print('.');
        this.output.print(keyword);
        for (Object param : parameters) {
            this.output.print(" | ");
            this.output.print(param);
        }
        this.output.println();
    }

    @Override
    public void setActualParameters(Object[] actualParameters) {
        this.output.println("Actual paramters: ");
        boolean first = true;
        for (Object param : actualParameters) {
            if (first) {
                first = false;
            } else {
                this.output.print(" | ");
            }
            this.output.print(param);
        }
    }

    @Override
    public void done(Date endDate) {
        this.output.println();
    }

    @Override
    public void incrementNestedInstruction(Date startDate) {
        this.prefix = this.prefix + "  ";
    }

    @Override
    public void decrementNestedInstruction(Date endDate) {
        this.prefix = this.prefix.length() <= 2 ? "" : this.prefix.substring(2);
    }

    @Override
    public void info(Exception ex) {
        ConsumableException iex;
        if (ex instanceof ConsumableException && (iex = (ConsumableException)ex).isConsumed()) {
            this.info(ex.getMessage());
            return;
        }
        this.output.print(this.prefix);
        this.output.print("INFO: ");
        ex.printStackTrace(this.output);
    }

    @Override
    public void info(String message) {
        this.output.print(this.prefix);
        this.output.print("INFO: ");
        this.output.println(message);
    }

    @Override
    public void warning(Exception ex) {
        ConsumableException iex;
        if (ex instanceof ConsumableException && (iex = (ConsumableException)ex).isConsumed()) {
            this.warning(ex.getMessage());
            return;
        }
        this.output.print(this.prefix);
        this.output.print("WARNING: ");
        ex.printStackTrace(this.output);
    }

    @Override
    public void warning(String message) {
        this.output.print(this.prefix);
        this.output.print("WARNING: ");
        this.output.println(message);
    }

    @Override
    public void error(Throwable ex) {
        ConsumableException iex;
        if (ex instanceof ConsumableException && (iex = (ConsumableException)ex).isConsumed()) {
            this.error(ex.getMessage());
            return;
        }
        this.output.print(this.prefix);
        this.output.print("ERROR: ");
        ex.printStackTrace(this.output);
    }

    @Override
    public void error(String message) {
        this.output.print(this.prefix);
        this.output.print("ERROR: ");
        this.output.println(message);
    }
}

