/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Processor;
import org.mazarineblue.keyworddriven.logs.Log;

public class LogChain
implements Log {
    private final List<Log> logs;

    public LogChain(Log ... logs) {
        this.logs = new ArrayList<Log>(Arrays.asList(logs));
    }

    public void add(Log log) {
        this.logs.add(log);
    }

    @Override
    public void info(String message) {
        for (Log log : this.logs) {
            log.info(message);
        }
    }

    @Override
    public void info(Exception ex) {
        for (Log log : this.logs) {
            log.info(ex);
        }
    }

    @Override
    public void warning(String message) {
        for (Log log : this.logs) {
            log.warning(message);
        }
    }

    @Override
    public void warning(Exception ex) {
        for (Log log : this.logs) {
            log.warning(ex);
        }
    }

    @Override
    public void error(String message) {
        for (Log log : this.logs) {
            log.error(message);
        }
    }

    @Override
    public void error(Throwable ex) {
        for (Log log : this.logs) {
            log.error(ex);
        }
    }

    @Override
    public void next(InstructionLine line, DataSource source, InterpreterContext context, Processor.ProcessingType processingType) throws IllegalSourceStateException {
        for (Log log : this.logs) {
            log.next(line, source, context, processingType);
        }
    }

    @Override
    public void setActualParameters(Object[] actualParameters) {
        for (Log log : this.logs) {
            log.setActualParameters(actualParameters);
        }
    }

    @Override
    public void done(Date endDate) {
        for (Log log : this.logs) {
            log.done(endDate);
        }
    }

    @Override
    public void incrementNestedInstruction(Date startDate) {
        for (Log log : this.logs) {
            log.incrementNestedInstruction(startDate);
        }
    }

    @Override
    public void decrementNestedInstruction(Date endDate) {
        for (Log log : this.logs) {
            log.decrementNestedInstruction(endDate);
        }
    }
}

