/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.logs;

import java.io.IOException;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.exceptions.SubscriberTargetException;
import org.mazarineblue.events.log.LogDecrementNestedLevelEvent;
import org.mazarineblue.events.log.LogIncrementNestedLevelEvent;
import org.mazarineblue.events.log.LogInstructionLineEvent;
import org.mazarineblue.events.log.LogStatusEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Processor;
import org.mazarineblue.keyworddriven.chainmanager.ChainManager;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.logs.dom.CollectionElement;
import org.mazarineblue.keyworddriven.logs.dom.Composite;
import org.mazarineblue.keyworddriven.logs.dom.LineElement;
import org.mazarineblue.keyworddriven.logs.dom.Status;
import org.mazarineblue.keyworddriven.logs.dom.StatusLeaf;
import org.mazarineblue.keyworddriven.logs.visitors.LogVisitor;

public class DomLog
implements Log {
    private final ChainManager chain;
    private final Deque<Composite> stack = new LinkedList<Composite>();
    private final CollectionElement root;
    private LineElement currentLineElement;

    public DomLog(ChainManager chain, Date startDate) {
        this.chain = chain;
        this.root = new CollectionElement(startDate);
        this.stack.add(this.root);
    }

    public void visitor(LogVisitor visitor) throws IOException {
        this.root.accept(visitor);
    }

    @Override
    public void next(InstructionLine line, DataSource dataSource, InterpreterContext context, Processor.ProcessingType processingType) throws IllegalSourceStateException {
        this.currentLineElement = new LineElement(line, context.startDate(), processingType);
        if (!line.isComment()) {
            this.stack.peek().add(this.currentLineElement);
        }
        this.stack.push(this.currentLineElement);
    }

    private void publish(Event event) {
        try {
            this.chain.publish(event);
        }
        catch (SubscriberTargetException ex) {
            throw Processor.convertException(ex);
        }
    }

    @Override
    public void setActualParameters(Object[] actualParameters) {
        this.currentLineElement.setActualParameters(actualParameters);
    }

    @Override
    public void done(Date endDate) {
        this.currentLineElement = null;
        Composite element = this.stack.pop();
        element.done(endDate);
        if (this.stack.isEmpty()) {
            this.root.done(endDate);
        } else {
            this.stack.peek().done(endDate);
        }
        this.publish((Event)new LogInstructionLineEvent(element));
    }

    @Override
    public void incrementNestedInstruction(Date startDate) {
        CollectionElement collection = new CollectionElement(startDate);
        this.stack.peek().add(collection);
        this.stack.push(collection);
        this.publish((Event)new LogIncrementNestedLevelEvent(collection));
    }

    @Override
    public void decrementNestedInstruction(Date endDate) {
        Composite element = this.stack.pop();
        element.done(endDate);
        this.publish((Event)new LogDecrementNestedLevelEvent(element));
    }

    @Override
    public void info(String message) {
        StatusLeaf leaf = this.stack.peek().add(Status.INFO, message);
        this.publish((Event)new LogStatusEvent(leaf));
    }

    protected InstructionLine getCurrentLine() {
        return this.currentLineElement == null ? null : this.currentLineElement.getInstructionLine();
    }

    @Override
    public void info(Exception ex) {
        StatusLeaf leaf = this.stack.peek().add(Status.INFO, ex);
        this.publish((Event)new LogStatusEvent(leaf));
    }

    @Override
    public void warning(String message) {
        StatusLeaf leaf = this.stack.peek().add(Status.WARNING, message);
        this.publish((Event)new LogStatusEvent(leaf));
    }

    @Override
    public void warning(Exception ex) {
        StatusLeaf leaf = this.stack.peek().add(Status.WARNING, ex);
        this.publish((Event)new LogStatusEvent(leaf));
    }

    @Override
    public void error(String message) {
        StatusLeaf leaf = this.stack.peek().add(Status.ERROR, message);
        this.publish((Event)new LogStatusEvent(leaf));
    }

    @Override
    public void error(Throwable ex) {
        StatusLeaf leaf = this.stack.peek().add(Status.ERROR, ex);
        this.publish((Event)new LogStatusEvent(leaf));
    }
}

