/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links.flow;

import java.util.Collection;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.events.instructions.ExecuteInstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.exceptions.BlockOpenOnEndSheetException;
import org.mazarineblue.keyworddriven.exceptions.GeneralParseException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.RecordingLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.LoopTester;
import org.mazarineblue.parser.ParserException;

public class WhileLoopLibraryLink
extends RecordingLibraryLink {
    private final String expression;
    private final LoopTester loopTester;

    public WhileLoopLibraryLink(Library library, LoopTester loopTester, String expression) {
        super(library);
        this.expression = expression;
        this.loopTester = loopTester;
    }

    @Keyword(value="End while")
    public void endWhile() {
        this.executor().chain().remove(this);
        try {
            Collection<InstructionLine> list = this.getRecording();
            block5: while (this.loopTester.continueLoop(this.expression)) {
                for (InstructionLine line : list) {
                    this.publish((Event)new ExecuteInstructionLineEvent(line, this));
                    if (!this.loopTester.isBroken()) continue;
                    continue block5;
                }
            }
        }
        catch (ParserException ex) {
            throw new GeneralParseException(this.expression);
        }
        finally {
            this.loopTester.removeLink(this.executor().chain());
        }
    }

    @EventHandler
    public void eventHandler(EndSheetEvent event) {
        throw new BlockOpenOnEndSheetException("While lus", event.getSheetName());
    }
}

