/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links.flow;

import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.exceptions.BlockOpenOnEndSheetException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.SkippableLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.BreakLibraryLink;

public class SwitchLibraryLink
extends SkippableLibraryLink {
    private final BreakLibraryLink breakLink;
    private final Object data;

    public SwitchLibraryLink(Library library, BreakLibraryLink breakLink, Object data) {
        super(library);
        this.breakLink = breakLink;
        this.data = data;
    }

    @Keyword(value="Case")
    @Parameters(min=1)
    public void flowCase(Object data) throws IllegalSourceStateException {
        this.next(this.data.equals(data), this.breakLink.isBroken());
    }

    @Keyword(value="Default case")
    public void flowDefaultCase() {
        this.next(true, this.breakLink.isBroken());
    }

    @Keyword(value="End switch")
    public void flowEndswitch() {
        this.executor().chain().remove(this);
        this.executor().chain().remove(this.breakLink);
    }

    @Override
    protected void processNonkeyEvents(InstructionLineEvent event) {
        this.next(false, this.breakLink.isBroken());
        super.processNonkeyEvents(event);
    }

    @EventHandler
    public void eventHandler(EndSheetEvent event) {
        throw new BlockOpenOnEndSheetException("Switch statement", event.getSheetName());
    }
}

