/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links.flow;

import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.exceptions.BlockOpenOnEndSheetException;
import org.mazarineblue.keyworddriven.exceptions.GeneralParseException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.SkippableLibraryLink;
import org.mazarineblue.keyworddriven.util.KeywordContainer;
import org.mazarineblue.parser.Parser;
import org.mazarineblue.parser.ParserException;
import org.mazarineblue.parser.VariableSource;

public class IfLibraryLink
extends SkippableLibraryLink {
    private Mode mode;
    private final Parser parser;

    public IfLibraryLink(Library library, Parser parser, String expression) {
        super(library);
        try {
            this.parser = parser;
            if (((Boolean)parser.parse(expression, (VariableSource)this.blackboard(), Boolean.class)).booleanValue()) {
                this.execute();
            }
        }
        catch (ParserException ex) {
            throw new GeneralParseException(expression);
        }
    }

    @KeywordContainer(value={@Keyword(value="Else if"), @Keyword(value="Elseif")})
    @Parameters(min=1)
    public void flowElseif(String expression) {
        try {
            boolean waitingCondition = (Boolean)this.parser.parse(expression, (VariableSource)this.blackboard(), Boolean.class);
            this.next(waitingCondition, true);
        }
        catch (ParserException ex) {
            throw new GeneralParseException(expression);
        }
    }

    @Keyword(value="Else")
    public void flowElse() {
        this.next();
    }

    @KeywordContainer(value={@Keyword(value="End if"), @Keyword(value="Endif")})
    public void flowEndif() {
        this.executor().chain().remove(this);
    }

    @EventHandler
    public void eventHandler(EndSheetEvent event) {
        throw new BlockOpenOnEndSheetException("If statement", event.getSheetName());
    }

    private static enum Mode {
        WAITING,
        EXECUTING,
        DONE;

    }
}

