/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links.flow;

import java.util.Collection;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.events.instructions.ExecuteInstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.exceptions.BlockOpenOnEndSheetException;
import org.mazarineblue.keyworddriven.exceptions.GeneralParseException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.RecordingLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.LoopTester;
import org.mazarineblue.parser.Parser;
import org.mazarineblue.parser.ParserException;
import org.mazarineblue.parser.VariableSource;

public class ForLibraryLink
extends RecordingLibraryLink {
    private final String variable;
    private final String expression;
    private final String increment;
    private final LoopTester loopTester;
    private final Parser variableParser;
    private final Parser operatorParser;

    public ForLibraryLink(Library library, LoopTester loopTester, Parser variableParser, Parser operatorParser, String variable, String terminination, String increment) {
        super(library);
        this.variableParser = variableParser;
        this.operatorParser = operatorParser;
        this.loopTester = loopTester;
        this.variable = variable;
        this.expression = terminination;
        this.increment = increment;
    }

    @Keyword(value="End for")
    public void endFor() {
        this.executor().chain().remove(this);
        Collection<InstructionLine> list = this.getRecording();
        try {
            while (this.loopTester.continueLoop(this.expression)) {
                for (InstructionLine line : list) {
                    this.publish((Event)new ExecuteInstructionLineEvent(line, this));
                    if (!this.loopTester.isBroken()) continue;
                    break;
                }
                this.increment();
            }
        }
        catch (ParserException ex) {
            throw new GeneralParseException(this.expression);
        }
        finally {
            this.loopTester.removeLink(this.executor().chain());
        }
    }

    private void increment() throws ParserException {
        String tmp = (String)this.variableParser.parse(this.increment, (VariableSource)this.blackboard(), String.class);
        Object data = this.operatorParser.parse(tmp, (VariableSource)this.blackboard());
        this.blackboard().setData(this.variable, data);
    }

    @EventHandler
    public void eventHandler(EndSheetEvent event) {
        throw new BlockOpenOnEndSheetException("For lus", event.getSheetName());
    }
}

