/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links;

import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.LibraryLink;

public class SkippableLibraryLink
extends LibraryLink {
    private Mode mode = Mode.WAITING;

    protected SkippableLibraryLink(Library library) {
        super(library);
    }

    protected SkippableLibraryLink(String namespace, Library library) {
        super(namespace, library);
    }

    protected Mode getMode() {
        return this.mode;
    }

    protected void next() {
        this.next(true, true);
    }

    protected void next(boolean waitingCondition, boolean executingCondition) {
        switch (this.mode) {
            case WAITING: {
                if (!waitingCondition) break;
                this.mode = Mode.EXECUTING;
                break;
            }
            case EXECUTING: {
                if (!executingCondition) break;
                this.mode = Mode.DONE;
                break;
            }
        }
    }

    protected void execute() {
        switch (this.mode) {
            case WAITING: {
                this.mode = Mode.EXECUTING;
                break;
            }
            case EXECUTING: {
                throw new IllegalStateException("Can not set link state to executing twice.");
            }
            case DONE: {
                throw new IllegalStateException("Can not set link state to executing once its done.");
            }
        }
    }

    protected void done() {
        this.mode = Mode.DONE;
    }

    @Override
    protected void processNonkeyEvents(InstructionLineEvent event) {
        if (this.mode == Mode.WAITING || this.mode == Mode.DONE) {
            event.setConsumed();
        }
    }

    protected static enum Mode {
        WAITING,
        EXECUTING,
        DONE;

    }
}

