/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links;

import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.links.KeywordCollection;
import org.mazarineblue.keyworddriven.links.Link;

public class ResolveKeywordConflictsLink
implements Link {
    private final KeywordCollection keywordCollection;

    public ResolveKeywordConflictsLink(String namespace, String ... keywords) {
        this.keywordCollection = new KeywordCollection(namespace, keywords);
    }

    @EventHandler
    public void eventHandler(InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        InstructionLine updatedLine = this.changeNamespace(line);
        event.push(updatedLine);
    }

    private InstructionLine changeNamespace(InstructionLine line) {
        if (!line.getNamespace().isEmpty()) {
            return line;
        }
        String keyword = line.getKeyword();
        if (!this.keywordCollection.containsKeyword(keyword)) {
            return line;
        }
        String namespace = this.keywordCollection.getNamespace();
        String lineIdentifier = line.getLineIdentifier();
        Object[] parameters = line.getParameters();
        return new InstructionLine(lineIdentifier, namespace, keyword, parameters);
    }
}

