/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.links;

import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.librarymanager.Instruction;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.Link;
import org.mazarineblue.keyworddriven.util.InstructionInvoker;

public abstract class LibraryLink
extends Library
implements Link {
    private final InstructionInvoker invoker = new InstructionInvoker(){

        @Override
        protected boolean skipInvokation(InstructionLineEvent event) {
            InstructionLine line = event.getLine();
            if (line.isEmpty()) {
                return false;
            }
            String namespace = line.getNamespace();
            if (namespace == null || namespace.isEmpty()) {
                return false;
            }
            return !namespace.equals(LibraryLink.this.getNamespace());
        }

        @Override
        protected Instruction getInstruction(InstructionLineEvent event) {
            InstructionLine line = event.getLine();
            String keyword = line.getKeyword();
            return LibraryLink.this.getInstructionDispatcher(keyword);
        }
    };

    protected LibraryLink(Library library) {
        super(library);
    }

    protected LibraryLink(String namespace, Library library) {
        super(namespace, library);
    }

    @Override
    protected void setEvents(EventService service) {
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void teardown() {
    }

    @EventHandler
    public void eventHandler(InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        if (line.isEmpty()) {
            return;
        }
        if (this.containsKeyword(line.getKeyword())) {
            this.processKeyEvents(event);
        } else {
            this.processNonkeyEvents(event);
        }
    }

    protected abstract void processNonkeyEvents(InstructionLineEvent var1);

    private void processKeyEvents(InstructionLineEvent event) {
        this.invoker.invoke(event);
    }

    private Instruction getInstructionDispatcher(String keyword) {
        return this.getInstruction(keyword);
    }
}

