/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.librarymanager;

import java.util.Collection;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.exceptions.ProcedureOpenOnStartException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.links.RecordingLibraryLink;
import org.mazarineblue.keyworddriven.proceduremanager.Procedure;
import org.mazarineblue.keyworddriven.proceduremanager.ProcedureManager;

public class ProcedureLibraryLink
extends RecordingLibraryLink {
    private final ProcedureManager procedureManager;
    private final String name;
    private final String[] parameters;
    boolean running = true;

    public ProcedureLibraryLink(Library library, ProcedureManager procedureManager, String name, String ... parameters) {
        super(library);
        this.procedureManager = procedureManager;
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    @Keyword(value="Procedure")
    @Parameters(min=1)
    public void procedure(String name, String ... paramters) {
        throw new ProcedureOpenOnStartException(name);
    }

    @Keyword(value="End procedure")
    @Parameters(min=0, max=0)
    public void endProcedure() {
        this.executor().chain().remove(this);
        Collection<InstructionLine> instructions = this.getRecording();
        Procedure procedure = new Procedure(this.parameters, instructions);
        this.procedureManager.register(this.name, procedure);
        this.running = false;
    }

    public boolean recoding() {
        return this.running;
    }
}

