/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.librarymanager;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Sentence;
import org.mazarineblue.keyworddriven.exceptions.KeywordConflictException;
import org.mazarineblue.keyworddriven.exceptions.KeywordNotFoundException;
import org.mazarineblue.keyworddriven.exceptions.LibraryNotFoundException;
import org.mazarineblue.keyworddriven.exceptions.SentenceConflictException;
import org.mazarineblue.keyworddriven.exceptions.SentenceNotFoundException;
import org.mazarineblue.keyworddriven.librarymanager.Instruction;
import org.mazarineblue.keyworddriven.librarymanager.Library;

public class LibraryManager {
    private InterpreterContext context;
    private final EventService eventService;
    private final Map<String, List<Library>> namespaces = new HashMap<String, List<Library>>(4);
    private final Map<Method, Library> methods = new HashMap<Method, Library>(32);
    private final Map<String, Instruction> keywords = new HashMap<String, Instruction>(32);
    private final Map<Pattern, Instruction> sentences = new HashMap<Pattern, Instruction>(1);

    public LibraryManager(EventService eventService, InterpreterContext context) {
        this.eventService = eventService;
        this.context = context;
    }

    public String toString() {
        String str = null;
        for (Map.Entry<String, List<Library>> entry : this.namespaces.entrySet()) {
            if (str == null) {
                str = this.toString(entry);
                continue;
            }
            str = str + ", " + this.toString(entry);
        }
        return str;
    }

    private String toString(Map.Entry<String, List<Library>> entry) {
        return entry.getKey() + '(' + entry.getValue().size() + ')';
    }

    public Library[] getLibrariesByNamespace(String namespace) {
        List<Library> libraries = this.namespaces.get(namespace);
        return libraries.toArray(new Library[libraries.size()]);
    }

    public Library getLibraryByMethod(Method method) {
        return this.methods.get(method);
    }

    public Instruction getInstructionByPath(String namespace, String keyword) {
        return namespace == null || namespace.isEmpty() ? this.globalSearch(keyword) : this.librarySearch(namespace, keyword);
    }

    private Instruction globalSearch(String keyword) {
        this.checkForGlobalKeyword(keyword);
        return this.getInstructionByKeyword(keyword);
    }

    private void checkForGlobalKeyword(String keyword) {
        if (this.keywords.containsKey(keyword)) {
            return;
        }
        for (List<Library> libraries : this.namespaces.values()) {
            for (Library library : libraries) {
                if (!library.containsKeyword(keyword)) continue;
                return;
            }
        }
        throw new KeywordNotFoundException("." + keyword);
    }

    private Instruction getInstructionByKeyword(String keyword) {
        Instruction instruction = this.keywords.get(keyword);
        if (instruction != null) {
            return instruction;
        }
        throw new KeywordConflictException(keyword);
    }

    private Instruction librarySearch(String namespace, String keyword) {
        this.checkForNamespace(namespace);
        return this.getInstructionByKeyword(namespace, keyword);
    }

    private void checkForNamespace(String namespace) {
        if (!this.namespaces.containsKey(namespace)) {
            throw new LibraryNotFoundException(namespace);
        }
    }

    private Instruction getInstructionByKeyword(String namespace, String keyword) {
        for (Library library : this.namespaces.get(namespace)) {
            Instruction instruction = library.getInstruction(keyword);
            if (instruction == null) continue;
            return instruction;
        }
        throw new KeywordNotFoundException(namespace + "." + keyword);
    }

    public Instruction getInstructionBySentence(String sentence) {
        for (Map.Entry<Pattern, Instruction> entry : this.sentences.entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher matcher = pattern.matcher(sentence);
            if (!matcher.find() || entry.getValue() == null) continue;
            return entry.getValue();
        }
        throw new SentenceNotFoundException(sentence);
    }

    public Instruction getInstructionBySentence(Pattern pattern) {
        Instruction instruction = this.sentences.get(pattern);
        if (instruction != null) {
            return instruction;
        }
        throw new SentenceNotFoundException(pattern);
    }

    public void register(Library ... libraries) {
        for (Library library : libraries) {
            library.setContext(this.context);
            library.setEvents(this.eventService);
            this.registerNamespace(library);
            this.registerMethods(library);
            this.registerKeywords(library);
        }
    }

    private void registerNamespace(Library library) {
        String namespace = library.getNamespace();
        List<Library> list = this.namespaces.get(namespace);
        if (list == null) {
            list = new ArrayList<Library>(4);
            this.namespaces.put(namespace, list);
        } else {
            list = this.namespaces.get(namespace);
        }
        list.add(library);
    }

    private void registerMethods(Library library) {
        for (Method method : library.getClass().getMethods()) {
            Keyword keyword = method.getAnnotation(Keyword.class);
            if (keyword == null) continue;
            this.methods.put(method, library);
        }
    }

    private void registerKeywords(Library library) {
        for (Method method : library.getClass().getMethods()) {
            for (Keyword keyword : (Keyword[])method.getAnnotationsByType(Keyword.class)) {
                this.registerKeyword(library, keyword.value(), method);
            }
        }
    }

    private void registerKeyword(Library library, String keyword, Method method) {
        Instruction instruction = this.keywords.containsKey(keyword) ? null : library.getInstruction(keyword);
        this.keywords.put(keyword, instruction);
    }

    private void registerSentences(Library library) {
        for (Method method : library.getClass().getMethods()) {
            Instruction instruction = this.getInstructionFromMethod(method);
            for (Sentence annotation : (Sentence[])method.getAnnotationsByType(Sentence.class)) {
                this.registerSentence(annotation, instruction);
            }
        }
    }

    private Instruction getInstructionFromMethod(Method method) {
        Library library = this.methods.get(method);
        Annotation[] arr = method.getAnnotationsByType(Keyword.class);
        String keyword = arr.length == 0 ? null : ((Keyword)arr[0]).value();
        return keyword == null ? library.getInstruction(keyword) : this.keywords.get(keyword);
    }

    private void registerSentence(Sentence sentence, Instruction instruction) {
        String key = sentence.value();
        Pattern pattern = Pattern.compile(key);
        this.registerSentence(pattern, instruction);
    }

    private void registerSentence(Pattern sentence, Instruction instruction) {
        if (this.sentences.containsKey(sentence)) {
            throw new SentenceConflictException(sentence);
        }
        this.sentences.put(sentence, instruction);
    }

    public void unregister(Library ... libraries) {
        for (Library library : libraries) {
            library.setContext(null);
            library.setEvents(null);
            this.unregisterNamespace(library);
            this.unregisterMethods(library);
            this.unregisterKeywords(library);
        }
    }

    private void unregisterNamespace(Library library) {
        String namespace = library.getNamespace();
        List<Library> list = this.namespaces.get(namespace);
        if (list == null) {
            return;
        }
        list = this.namespaces.get(namespace);
        list.remove(library);
    }

    private void unregisterMethods(Library library) {
        for (Method method : library.getClass().getMethods()) {
            this.methods.remove(method);
        }
    }

    private void unregisterKeywords(Library library) {
        for (Method method : library.getClass().getMethods()) {
            Keyword keyword = method.getAnnotation(Keyword.class);
            if (keyword == null) continue;
            this.unregisterKeyword(library, keyword.value(), method);
        }
    }

    private void unregisterKeyword(Library library, String keyword, Method method) {
        if (!this.keywords.containsKey(keyword)) {
            return;
        }
        Instruction instruction = this.keywords.get(keyword);
        if (instruction == null) {
            Library[] arr = this.getLibrariesByByKeyword(keyword);
            if (arr.length == 1) {
                this.keywords.put(keyword, arr[0].getInstruction(keyword));
            }
        } else {
            this.keywords.remove(keyword);
        }
    }

    public final Library[] getLibrariesByByKeyword(String keyword) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (List<Library> list : this.namespaces.values()) {
            for (Library library : list) {
                if (!library.containsKeyword(keyword)) continue;
                libraries.add(library);
            }
        }
        return libraries.toArray(new Library[libraries.size()]);
    }

    public void setup(InterpreterContext context) {
        for (List<Library> libraries : this.namespaces.values()) {
            for (Library library : libraries) {
                library.setContext(context);
                library.setup();
            }
        }
    }

    public void teardown() {
        for (List<Library> libraries : this.namespaces.values()) {
            for (Library library : libraries) {
                library.teardown();
                library.setContext(null);
            }
        }
    }
}

