/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.librarymanager;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mazarineblue.datasources.BlackboardSource;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.eventbus.ReflectionSubscriber;
import org.mazarineblue.eventbus.Subscriber;
import org.mazarineblue.eventbus.exceptions.EventServiceException;
import org.mazarineblue.eventbus.exceptions.SubscriberTargetException;
import org.mazarineblue.events.GetDataSourceEvent;
import org.mazarineblue.events.library.FetchLibrariesEvent;
import org.mazarineblue.events.library.FetchLibraryEvent;
import org.mazarineblue.keyworddriven.Beta;
import org.mazarineblue.keyworddriven.DocumentMediator;
import org.mazarineblue.keyworddriven.Interpreter;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.SheetFactory;
import org.mazarineblue.keyworddriven.exceptions.ConsumableException;
import org.mazarineblue.keyworddriven.exceptions.KeywordConflictException;
import org.mazarineblue.keyworddriven.feeds.Feed;
import org.mazarineblue.keyworddriven.librarymanager.Instruction;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.logs.NullLog;

public abstract class Library
implements ReflectionSubscriber<Event> {
    private final String namespace;
    private final Map<String, Instruction> keywords = new HashMap<String, Instruction>(4);
    private EventService events;
    private InterpreterContext context;

    protected Library(Library library) {
        this(library.namespace, library);
    }

    protected Library(String namespace, Library library) {
        this(namespace);
        this.setEvents(library.events);
        this.setContext(library.context);
    }

    protected Library(String namespace) {
        this.namespace = namespace;
        this.registerInstructions(this.getClass());
    }

    public String toString() {
        return "Library{namespace=" + this.namespace + ", class=" + this.getClass() + '}';
    }

    protected void setEvents(EventService service) {
        if (this.events != null) {
            this.events.unsubscribe(Event.class, null, (Subscriber)this);
        }
        this.events = service;
        this.subscribingMyEventHandlers();
    }

    private void subscribingMyEventHandlers() {
        try {
            if (this.events != null) {
                this.events.subscribe(Event.class, null, (Subscriber)this);
            }
        }
        catch (EventServiceException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void setup(Library library) {
        this.setContext(library.context);
        this.setup();
    }

    final void setContext(InterpreterContext context) {
        this.context = context;
    }

    private <T> void registerInstructions(Class<T> instructionClass) {
        for (Method method : instructionClass.getMethods()) {
            if (!Library.class.isAssignableFrom(method.getDeclaringClass())) continue;
            this.registersKeywords(method);
        }
    }

    private void registersKeywords(Method method) {
        for (Keyword keyword : (Keyword[])method.getAnnotationsByType(Keyword.class)) {
            Instruction instruction = new Instruction(this, keyword, method);
            if (((Beta[])method.getAnnotationsByType(Beta.class)).length > 0) {
                instruction.setBeta(true);
            }
            if (((Deprecated[])method.getAnnotationsByType(Deprecated.class)).length > 0) {
                instruction.setDeprecated(true);
            }
            this.setInstruction(instruction);
        }
    }

    final void setInstruction(Instruction instruction) {
        String keyword = instruction.getKeyword();
        if (this.keywords.containsKey(keyword)) {
            throw new KeywordConflictException(keyword);
        }
        this.keywords.put(keyword, instruction);
    }

    private boolean equalMethods(Method expected, Method actual) {
        Class<?>[] actualClazz;
        if (!expected.getName().equals(actual.getName())) {
            return false;
        }
        Class<?>[] expectedClazz = expected.getParameterTypes();
        if (expectedClazz.length != (actualClazz = actual.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < expectedClazz.length; ++i) {
            if (expectedClazz[i].isAssignableFrom(actualClazz[i])) continue;
            return false;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.getDataSource(null);
    }

    public final DataSource getDataSource(String name) {
        try {
            GetDataSourceEvent event = new GetDataSourceEvent();
            this.events.publish((Event)event);
            return (DataSource)event.get(DataSource.class);
        }
        catch (SubscriberTargetException ex) {
            throw new ConsumableException(ex.getCause());
        }
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public boolean containsKeyword(String keyword) {
        return this.keywords.containsKey(keyword);
    }

    public final String[] getKeywords() {
        return this.keywords.keySet().toArray(new String[this.keywords.size()]);
    }

    public final Instruction[] getInstructions() {
        return this.keywords.values().toArray(new Instruction[this.keywords.size()]);
    }

    public final Instruction getInstruction(String keyword) {
        return this.keywords.get(keyword);
    }

    public boolean hasInstruction(String keyword) {
        return this.keywords.containsKey(keyword);
    }

    public void publish(Event event) {
        try {
            this.executor().publish(event);
        }
        catch (SubscriberTargetException ex) {
            throw new ConsumableException(ex.getCause());
        }
    }

    public final InterpreterContext context() {
        return this.context;
    }

    public final Interpreter executor() {
        return this.context == null ? null : this.context.executor();
    }

    public final Feed feed() {
        return this.context == null ? null : this.context.feed();
    }

    public final Log log() {
        return this.context == null ? NullLog.getDefaultInstance() : this.context.log();
    }

    public final BlackboardSource blackboard() {
        return this.context == null ? null : this.context.blackboard();
    }

    public final SheetFactory sheetFactory() {
        return this.context == null ? null : this.context.sheetFactory();
    }

    public final DocumentMediator documentMediator() {
        return this.context == null ? null : this.context.documentMediator();
    }

    protected abstract void setup();

    protected abstract void teardown();

    @EventHandler
    public void eventHandler(FetchLibraryEvent event) {
        if (!event.containsLibraryClass(this.getClass())) {
            return;
        }
        event.setLibrary(this);
    }

    @EventHandler
    public void eventHandler(FetchLibrariesEvent event) {
        if (!event.containsLibraryClass(this.getClass())) {
            return;
        }
        event.addLibrary(this);
    }
}

