/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.librarymanager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.Processor;
import org.mazarineblue.keyworddriven.exceptions.InstructionUnaccessableException;
import org.mazarineblue.keyworddriven.exceptions.InvalidParameterException;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.util.methods.MethodWrapper;

public class Instruction {
    private static String betaInstructionTxt = "Beta instruction - the usage of this instruction is discuraged";
    private static String deprecatedInstructionTxt = "Deprecated instruction - the usage of this instruction is discuraged";
    private final Library library;
    private final String keyword;
    private final MethodWrapper method;
    private final Parameters parameters;
    private boolean beta = false;
    private boolean deprecated = false;

    Instruction(Library library, Keyword keyword, Method method) {
        this.library = library;
        this.keyword = keyword.value();
        this.parameters = method.getAnnotation(Parameters.class);
        this.method = new MethodWrapper(method, library.getNamespace() + "." + keyword);
    }

    void setBeta(boolean flag) {
        this.beta = flag;
    }

    void setDeprecated(boolean flag) {
        this.deprecated = flag;
    }

    public String toString() {
        return this.keyword;
    }

    public Library getLibrary() {
        return this.library;
    }

    public String getPath() {
        return this.library.getNamespace() + "." + this.keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void validate(Object[] parameters) {
        if (this.beta) {
            this.library.log().warning(betaInstructionTxt);
        }
        if (this.deprecated) {
            this.library.log().warning(deprecatedInstructionTxt);
        }
        this.method.check(parameters);
    }

    public void invoke(Object[] parameters) {
        try {
            this.method.invoke(this.library, parameters);
        }
        catch (IllegalAccessException ex) {
            throw new InstructionUnaccessableException(this.getPath());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidParameterException(this.getPath(), Instruction.toString(parameters));
        }
        catch (InvocationTargetException ex) {
            String error = this.getErrorMessage(ex);
            throw Processor.convertException(error, ex);
        }
    }

    private static String toString(Object[] parameters) {
        String str = null;
        for (Object param : parameters) {
            str = str == null ? param.toString() : str + ", " + param.toString();
        }
        return str;
    }

    public String getErrorMessage(Throwable cause) {
        String format = "Instruction %s resulted in error: %s";
        String msg = cause.getMessage();
        if (msg == null) {
            if (cause instanceof NullPointerException) {
                format = "Developer issue: Null pointer exception %s";
                msg = String.format(format, this.getPath());
            } else if (cause instanceof ArrayIndexOutOfBoundsException) {
                format = "Developer issue: Array index out of bounds at instruction %s";
                msg = String.format(format, this.getPath());
            } else {
                msg = "sorry, no message available!";
            }
        }
        return String.format(format, this.getPath(), msg);
    }
}

