/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.librarymanager;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.ObjectArraySource;
import org.mazarineblue.datasources.exceptions.BlackboardException;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.events.SetStatusEvent;
import org.mazarineblue.events.StartSheetEvent;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.exceptions.ConsumableException;
import org.mazarineblue.keyworddriven.exceptions.InstructionUnaccessableException;
import org.mazarineblue.keyworddriven.exceptions.LibraryNotFoundException;
import org.mazarineblue.keyworddriven.exceptions.LibraryUninstantiableException;
import org.mazarineblue.keyworddriven.exceptions.NoMatchException;
import org.mazarineblue.keyworddriven.exceptions.ParseExpressionException;
import org.mazarineblue.keyworddriven.exceptions.ProcedureOpenOnSheetEndException;
import org.mazarineblue.keyworddriven.exceptions.ProcedureOpenOnStartException;
import org.mazarineblue.keyworddriven.exceptions.ScopeNotFoundException;
import org.mazarineblue.keyworddriven.exceptions.SheetNotFoundException;
import org.mazarineblue.keyworddriven.exceptions.VariableAlreadyDeclaredException;
import org.mazarineblue.keyworddriven.feeds.Feed;
import org.mazarineblue.keyworddriven.librarymanager.Library;
import org.mazarineblue.keyworddriven.librarymanager.ProcedureLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.BreakLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.DoLoopLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.ForLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.IfLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.LoopTester;
import org.mazarineblue.keyworddriven.links.flow.SwitchLibraryLink;
import org.mazarineblue.keyworddriven.links.flow.WhileLoopLibraryLink;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.proceduremanager.ProcedureManager;
import org.mazarineblue.parser.Parser;
import org.mazarineblue.parser.ParserException;
import org.mazarineblue.parser.VariableSource;
import org.mazarineblue.parser.precedenceclimbing.DefaultOperatorParser;
import org.mazarineblue.parser.variable.VariableParser;

public class DefaultLibrary
extends Library {
    private final ClassLoader classLoader;
    private final ProcedureManager procedureManager;
    private static final Parser parser = new VariableParser();
    private static final DefaultOperatorParser operatorParser = new DefaultOperatorParser();
    private static String[] libraryPostfixes = new String[]{".keywords.DefaultLibrary", ".DefaultLibrary"};
    private ProcedureLibraryLink procedure;

    public DefaultLibrary(EventService eventService, ProcedureManager procedureManager) {
        super("org.mazarineblue");
        this.setEvents(eventService);
        this.classLoader = this.getClass().getClassLoader();
        this.procedureManager = procedureManager;
    }

    @Override
    protected void setup() {
    }

    @Override
    protected void teardown() {
    }

    @Keyword(value="Import")
    @Parameters(min=1, max=1)
    public void importLibrary(String path) {
        Class<?> type = this.loadClass(path, libraryPostfixes);
        if (!this.isLibrary(type)) {
            throw new LibraryNotFoundException(path);
        }
        Library library = this.createLibrary(path, type);
        this.executor().libraries().register(library);
    }

    private Class<?> loadClass(String path, String[] arr) {
        for (String str : arr) {
            if (!this.hasClass(path + str)) continue;
            return this.loadClass(path + str);
        }
        return this.loadClass(path);
    }

    private boolean hasClass(String path) {
        try {
            this.classLoader.loadClass(path);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private Class<?> loadClass(String path) {
        try {
            return this.classLoader.loadClass(path);
        }
        catch (ClassNotFoundException ex) {
            throw new LibraryNotFoundException(path);
        }
    }

    private boolean isLibrary(Class type) {
        return Library.class.isAssignableFrom(type);
    }

    private Library createLibrary(String path, Class type) {
        try {
            Library library = (Library)type.newInstance();
            library.setup(this);
            return library;
        }
        catch (IllegalAccessException ex) {
            throw new InstructionUnaccessableException(path, ex);
        }
        catch (InstantiationException ex) {
            throw new LibraryUninstantiableException(path, ex);
        }
    }

    @Keyword(value="Comment")
    @Parameters(min=0)
    public void comment(String ... param) {
    }

    @Keyword(value="Echo")
    @Parameters(min=1)
    public void echo(String ... param) {
        System.out.println(this.toSingleLine(param));
    }

    private String toSingleLine(String ... param) {
        String output = "";
        for (String str : param) {
            output = output + str + ", ";
        }
        int n = output.length();
        if (output.length() >= 2) {
            output = output.substring(0, n - 2);
        }
        return output;
    }

    @Keyword(value="Info")
    @Parameters(min=1)
    public void info(String ... msg) {
        this.log().info(this.toSingleLine(msg));
    }

    @Keyword(value="Warning")
    @Parameters(min=1)
    public void warning(String ... msg) {
        this.log().warning(this.toSingleLine(msg));
    }

    @Keyword(value="Error")
    @Parameters(min=1)
    public void error(String ... msg) {
        this.log().error(this.toSingleLine(msg));
    }

    @Keyword(value="Exception")
    @Parameters(min=1)
    public void exception(String ... msg) {
        throw new ConsumableException("Error message: " + this.toSingleLine(msg));
    }

    @Keyword(value="Sleep")
    @Parameters(min=1, max=1)
    public void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    @Keyword(value="Set delay")
    @Parameters(min=1, max=1)
    public void setDelay(long millis) throws InterruptedException {
        this.executor().setSleep(millis);
    }

    @Keyword(value="Call sheet")
    public void callSheet(String sheetName) {
        try {
            this.procedureManager.pushScope();
            this.blackboard().pushSource("Sheet");
            this.importSheet(sheetName);
            this.blackboard().popSource("Sheet");
            this.procedureManager.popScope();
        }
        catch (BlackboardException ex) {
            throw new SheetNotFoundException(sheetName, ex);
        }
    }

    @Keyword(value="Import sheet")
    public final void importSheet(String sheetName) {
        this.publish((Event)new StartSheetEvent(sheetName));
        Feed feed = this.sheetFactory().getSheetFeed(sheetName);
        Log log = this.log();
        InterpreterContext context = this.context();
        this.executor().executeNested(feed, log, context);
        this.publish((Event)new EndSheetEvent(sheetName));
    }

    @Keyword(value="Procedure")
    @Parameters(min=1)
    public void procedure(String name, String ... paramters) {
        if (this.procedure != null && this.procedure.recoding()) {
            throw new ProcedureOpenOnStartException(this.procedure.getName());
        }
        this.procedure = new ProcedureLibraryLink(this, this.procedureManager, name, paramters);
        this.executor().chain().insert(this.procedure);
    }

    @EventHandler
    public void eventHandler(EndSheetEvent event) {
        if (this.procedure != null && this.procedure.recoding()) {
            throw new ProcedureOpenOnSheetEndException(event.getSheetName());
        }
    }

    @Keyword(value="Call procedure")
    @Parameters(min=1)
    public void callProcedure(String name, Object ... parameters) {
        InterpreterContext context = this.context();
        this.procedureManager.execute(name, parameters, context);
    }

    @Keyword(value="Declare global variable")
    @Parameters(min=1)
    public void declareGlobalVariable(String name) {
        try {
            this.blackboard().declareVariable(name);
        }
        catch (BlackboardException ex) {
            throw new VariableAlreadyDeclaredException(name, ex);
        }
    }

    @Deprecated
    @Keyword(value="Declare sheet variable")
    @Parameters(min=1)
    public void declareSheetVariable(String name) {
        try {
            this.blackboard().declareVariable("Sheet", name);
        }
        catch (BlackboardException ex) {
            throw new VariableAlreadyDeclaredException(name, ex);
        }
    }

    @Keyword(value="Declare variable")
    @Parameters(min=1)
    public void declareVariable(String name) {
        try {
            this.blackboard().declareVariable("Local", name);
        }
        catch (BlackboardException ex) {
            throw new VariableAlreadyDeclaredException(name, ex);
        }
    }

    @Keyword(value="Set")
    @Parameters(min=1)
    public void set(String name, Object value) {
        this.blackboard().setData(name, value);
    }

    @Keyword(value="Set condition")
    public void setCondiation(String name, String expression) {
        try {
            DefaultOperatorParser operatorParser = new DefaultOperatorParser();
            Object value = operatorParser.parse(expression, (VariableSource)this.blackboard(), Object.class);
            this.blackboard().setData(name, value);
        }
        catch (ParserException ex) {
            throw new ParseExpressionException(expression, ex);
        }
    }

    @Keyword(value="Validate condition")
    public void validateCondition(String expression) {
        try {
            Boolean result = (Boolean)operatorParser.parse(expression, (VariableSource)this.blackboard(), Boolean.class);
            this.publish((Event)new SetStatusEvent(result.booleanValue()));
        }
        catch (ParserException ex) {
            throw new ParseExpressionException(expression, ex);
        }
    }

    @Keyword(value="Substring")
    @Parameters(min=4)
    public void substring(String input, String variable, String regex, String replacement) {
        Matcher matcher = this.fetchMatcher(regex, input);
        DataSource source = this.fetchRegexMappingSource(matcher);
        this.copyOutputToBlackboard(variable, replacement, source);
    }

    private Matcher fetchMatcher(String regex, String input) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher;
        }
        throw new NoMatchException(regex, input);
    }

    private DataSource fetchRegexMappingSource(Matcher matcher) {
        ObjectArraySource source = new ObjectArraySource("Substring-source", true);
        int n = matcher.groupCount();
        for (int i = 0; i <= n; ++i) {
            source.put(Integer.toString(i), (Object)matcher.group(i));
        }
        return source;
    }

    private void copyOutputToBlackboard(String variable, String replacement, DataSource source) {
        try {
            Object output = parser.parse(replacement, (VariableSource)source);
            this.blackboard().setData(variable, output);
        }
        catch (ParserException ex) {
            throw new ParseExpressionException(replacement, ex);
        }
    }

    @Keyword(value="If")
    @Parameters(min=1)
    public void flowIf(String expression) {
        IfLibraryLink link = new IfLibraryLink(this, (Parser)operatorParser, expression);
        this.executor().chain().insert(link);
    }

    @Keyword(value="Switch")
    @Parameters(min=1)
    public void flowSwitch(Object data) {
        try {
            this.blackboard().pushSource("switch");
            BreakLibraryLink breakLink = new BreakLibraryLink(this, (Parser)operatorParser);
            SwitchLibraryLink link = new SwitchLibraryLink(this, breakLink, data);
            this.executor().chain().insert(breakLink);
            this.executor().chain().insert(link);
            this.blackboard().popSource("switch");
        }
        catch (BlackboardException ex) {
            throw new ScopeNotFoundException("switch", ex);
        }
    }

    @Keyword(value="Do")
    public void flowDo() {
        try {
            this.blackboard().pushSource("do-loop");
            BreakLibraryLink breakLink = new BreakLibraryLink(this, (Parser)operatorParser);
            LoopTester loopTester = new LoopTester(parser, breakLink, (VariableSource)this.blackboard());
            DoLoopLibraryLink link = new DoLoopLibraryLink(this, loopTester);
            this.executor().chain().insert(breakLink);
            this.executor().chain().insert(link);
            this.blackboard().popSource("do-loop");
        }
        catch (BlackboardException ex) {
            throw new ScopeNotFoundException("do-loop", ex);
        }
    }

    @Keyword(value="While")
    public void flowWhile(String expression) {
        expression = this.getUnprocessedExpression(0);
        try {
            this.blackboard().pushSource("while-loop");
            BreakLibraryLink breakLink = new BreakLibraryLink(this, (Parser)operatorParser);
            LoopTester loopTester = new LoopTester(parser, breakLink, (VariableSource)this.blackboard());
            WhileLoopLibraryLink link = new WhileLoopLibraryLink(this, loopTester, expression);
            this.executor().chain().insert(breakLink);
            this.executor().chain().insert(link);
            this.blackboard().popSource("while-loop");
        }
        catch (BlackboardException ex) {
            throw new ScopeNotFoundException("while-loop", ex);
        }
    }

    private String getUnprocessedExpression(int index) {
        return (String)this.context().getUnprocessedLine().getParameter(index);
    }

    @Keyword(value="For")
    @Parameters(min=4)
    public void flowFor(String variable, String initialization, String terminination, String increment) {
        terminination = this.getUnprocessedExpression(2);
        increment = this.getUnprocessedExpression(3);
        try {
            this.blackboard().pushSource("for-loop");
            Object data = parser.parse(initialization, (VariableSource)this.blackboard());
            this.blackboard().setData(variable, data);
            BreakLibraryLink breakLink = new BreakLibraryLink(this, (Parser)operatorParser);
            LoopTester loopTester = new LoopTester(parser, breakLink, (VariableSource)this.blackboard());
            ForLibraryLink link = new ForLibraryLink(this, loopTester, parser, (Parser)operatorParser, variable, terminination, increment);
            this.executor().chain().insert(breakLink);
            this.executor().chain().insert(link);
            this.blackboard().popSource("for-loop");
        }
        catch (ParserException ex) {
            throw new ParseExpressionException(increment, ex);
        }
        catch (BlackboardException ex) {
            throw new ScopeNotFoundException("for-loop", ex);
        }
    }
}

