/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.feeds;

import java.util.ArrayList;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.DataValidationException;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.exceptions.FeedColumnValidationException;
import org.mazarineblue.keyworddriven.exceptions.IllegalFeedStateException;
import org.mazarineblue.keyworddriven.feeds.Feed;

public class DataSourceFeed
implements Feed {
    private final DataSource source;

    public DataSourceFeed(DataSource source) {
        this.source = source;
    }

    @Override
    public String getIdentifier() {
        return this.source.getSourceIdentifier();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public InstructionLine next() {
        try {
            this.source.next();
            String lineIdentifier = this.source.getLineIdentifier();
            String namespace = this.getNamespace();
            String keyword = this.getKeyword();
            Object[] parameters = this.getParameters();
            return new InstructionLine(lineIdentifier, namespace, keyword, parameters);
        }
        catch (IllegalSourceStateException ex) {
            throw new IllegalFeedStateException(ex);
        }
    }

    private String getNamespace() {
        try {
            String path = this.getPath();
            return InstructionLine.getNamespace(path);
        }
        catch (IllegalSourceStateException ex) {
            throw new IllegalFeedStateException(ex);
        }
        catch (DataValidationException ex) {
            throw new FeedColumnValidationException(ex);
        }
    }

    private String getPath() throws IllegalSourceStateException, DataValidationException {
        String path = (String)this.source.getData(0, String.class);
        return path == null ? "" : path;
    }

    private String getKeyword() {
        try {
            String path = this.getPath();
            return InstructionLine.getKeyword(path);
        }
        catch (IllegalSourceStateException ex) {
            throw new IllegalFeedStateException(ex);
        }
        catch (DataValidationException ex) {
            throw new FeedColumnValidationException(ex);
        }
    }

    private Object[] getParameters() throws IllegalFeedStateException {
        try {
            Object obj;
            int index = 0;
            ArrayList<Object> list = new ArrayList<Object>();
            while ((obj = this.source.getData(++index)) != null) {
                list.add(obj);
            }
            return list.toArray();
        }
        catch (IllegalSourceStateException ex) {
            throw new IllegalFeedStateException(ex);
        }
    }
}

