/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.feeds;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.exceptions.IllegalFeedStateException;
import org.mazarineblue.keyworddriven.feeds.Feed;

public class CollectionFeed
implements Feed {
    private final Collection<InstructionLine> collection;
    private Iterator<InstructionLine> iterator;
    private InstructionLine current;

    public CollectionFeed(InstructionLine ... lines) {
        this(Arrays.asList(lines));
    }

    public CollectionFeed(Collection<InstructionLine> collection) {
        this.collection = collection;
    }

    @Override
    public String getIdentifier() {
        return "CollectionFeed";
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.collection.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public InstructionLine next() {
        try {
            if (this.iterator == null) {
                this.iterator = this.collection.iterator();
            }
            this.current = this.iterator.next();
            return this.current;
        }
        catch (NoSuchElementException ex) {
            throw new IllegalFeedStateException(ex);
        }
    }
}

