/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.documentMediators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.mazarineblue.keyworddriven.DocumentMediator;
import org.mazarineblue.util.Timestamp;

public class FileDocumentMediator
implements DocumentMediator {
    private final Path baseDirectory;
    private final File input;
    private File logFile;
    private File reportFile;

    public FileDocumentMediator(File input) {
        this.input = input = input.getAbsoluteFile();
        File parent = input.getParentFile();
        this.baseDirectory = parent.toPath();
    }

    @Override
    public Timestamp getDefaultTimestamp() {
        return Timestamp.getDefaultInstance((String)"yyyy-MM-dd_HH-mm-ss");
    }

    @Override
    public String getDefaultFolder(Date date) {
        String name = this.input.getName();
        String timestamp = this.getDefaultTimestamp().getTimestamp(date);
        return "Logs for " + name + "/" + timestamp;
    }

    @Override
    public String getInputLocation() {
        return this.input.getAbsolutePath();
    }

    protected File getLogFile() {
        if (this.logFile == null) {
            throw new IllegalStateException("The log should be written first");
        }
        return this.logFile;
    }

    protected File getReportFile() {
        if (this.reportFile == null) {
            throw new IllegalStateException("The report should be written first");
        }
        return this.reportFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.input);
    }

    @Override
    public InputStream getInputStream(Path path) throws IOException {
        File file = this.baseDirectory.resolve(path).toFile();
        return new FileInputStream(file);
    }

    @Override
    public OutputStream getLogOutputStream(String directory, String dummyName) throws IOException {
        File dir = new File(this.baseDirectory.toFile(), directory);
        this.setupTemplateFiles(dir);
        this.logFile = new File(dir, "log.xml");
        return new FileOutputStream(this.logFile);
    }

    @Override
    public OutputStream getReportOutputStream(String directory, String reportName) throws IOException {
        File dir = new File(this.baseDirectory.toFile(), directory);
        this.setupTemplateFiles(dir);
        this.reportFile = new File(dir, reportName + ".xml");
        return new FileOutputStream(this.reportFile);
    }

    private void setupTemplateFiles(File dest) throws IOException {
        File file;
        if (dest == null) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((file = new File(dest, "main.css")).exists()) {
            return;
        }
        this.setupTemplateFiles(dest, "main");
        this.setupTemplateFiles(dest, "log");
        this.setupTemplateFiles(dest, "report");
    }

    private void setupTemplateFiles(File dest, String template) throws IOException {
        FileUtils.copyFileToDirectory((File)new File(this.baseDirectory.toFile(), template + ".xsl"), (File)dest);
        FileUtils.copyFileToDirectory((File)new File(this.baseDirectory.toFile(), template + ".css"), (File)dest);
    }

    @Override
    public OutputStream getOutputStream(Path path) throws IOException {
        File file = this.baseDirectory.resolve(path).toFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new FileOutputStream(file);
    }
}

