/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.chainmanager;

import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.instructions.ExecuteInstructionLineEvent;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.links.Link;
import org.mazarineblue.keyworddriven.proceduremanager.ProcedureManager;

public class ProcedureDispatcherLink
implements Link {
    private final ProcedureManager procedureManager;

    ProcedureDispatcherLink(ProcedureManager procedureManager) {
        this.procedureManager = procedureManager;
    }

    @EventHandler
    public void eventHandler(InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        DataSource source = event.getDataSource();
        InterpreterContext context = event.getContext();
        if (!this.procedureManager.contains(line)) {
            return;
        }
        if (event instanceof ExecuteInstructionLineEvent) {
            this.procedureManager.execute(line, source, context);
        }
        event.setConsumed();
    }
}

