/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.chainmanager;

import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.events.instructions.InstructionLineEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.exceptions.GeneralParseException;
import org.mazarineblue.keyworddriven.links.Link;
import org.mazarineblue.parser.Parser;
import org.mazarineblue.parser.ParserException;
import org.mazarineblue.parser.VariableSource;

public class ConvertLineParametersLink
implements Link {
    private final Parser parser;

    ConvertLineParametersLink(Parser parser) {
        this.parser = parser;
    }

    @EventHandler
    public void eventHandler(InstructionLineEvent event) {
        InstructionLine line = event.getLine();
        if (line.isEmpty()) {
            return;
        }
        String lineIdentifier = line.getLineIdentifier();
        String namespace = line.getNamespace();
        String keyword = line.isComment() ? "Comment" : line.getKeyword();
        try {
            DataSource source = event.getDataSource();
            InterpreterContext context = event.getContext();
            Object[] parameters = line.getParameters();
            parameters = this.parser.parse(parameters, (VariableSource)source);
            context.log().setActualParameters(parameters);
            event.push(new InstructionLine(lineIdentifier, namespace, keyword, parameters));
        }
        catch (ParserException ex) {
            throw new GeneralParseException(ex.getMessage(), ex);
        }
    }
}

