/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.chainmanager;

import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.keyworddriven.chainmanager.Chain;
import org.mazarineblue.keyworddriven.chainmanager.ConvertLineParametersLink;
import org.mazarineblue.keyworddriven.chainmanager.EventServiceLink;
import org.mazarineblue.keyworddriven.chainmanager.LibraryDispatcherLink;
import org.mazarineblue.keyworddriven.chainmanager.ProcedureDispatcherLink;
import org.mazarineblue.keyworddriven.librarymanager.LibraryManager;
import org.mazarineblue.keyworddriven.links.Link;
import org.mazarineblue.keyworddriven.proceduremanager.ProcedureManager;
import org.mazarineblue.parser.Parser;

public class ChainManager {
    private final LibraryManager libraryManager;
    private Chain chain;

    public ChainManager(ProcedureManager procedureManager, LibraryManager libraryManager, Parser parser, EventService<Event> eventService) {
        this.libraryManager = libraryManager;
        this.chain = new Chain(this.createDefaultLinks(procedureManager, libraryManager, parser, eventService));
    }

    private Link[] createDefaultLinks(ProcedureManager procedureManager, LibraryManager libraryManager, Parser parser, EventService<Event> eventService) {
        Link[] arr = new Link[]{new ConvertLineParametersLink(parser), new ProcedureDispatcherLink(procedureManager), new LibraryDispatcherLink(libraryManager), new EventServiceLink(eventService)};
        return arr;
    }

    public void publish(Event event) {
        this.chain.eventHandler(event);
    }

    public void insert(Link link) {
        this.chain = new Chain(link, this.chain);
    }

    public boolean remove(Link link) {
        if (this.chain == null) {
            return false;
        }
        if (this.chain.firstLinkEqualsTo(link)) {
            this.chain = this.chain.next();
            return true;
        }
        return this.chain.remove(link);
    }

    public int fetchChainCount() {
        int count = 0;
        Chain tmp = this.chain;
        while (tmp != null) {
            tmp = tmp.next();
            ++count;
        }
        return count;
    }
}

