/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven.chainmanager;

import org.mazarineblue.eventbus.Event;
import org.mazarineblue.keyworddriven.links.Link;

class Chain {
    private final Link link;
    private Chain next;

    Chain(Link link) {
        this.link = link;
        this.next = null;
    }

    Chain(Link ... link) {
        this.next = null;
        for (int i = link.length - 1; i > 0; --i) {
            this.next = new Chain(link[i], this.next);
        }
        this.link = link[0];
    }

    Chain(Link link, Chain next) {
        this.link = link;
        this.next = next;
    }

    Chain next() {
        return this.next;
    }

    void eventHandler(Event event) {
        this.link.eventHandler(event);
        if (event.isConsumed()) {
            return;
        }
        if (this.next != null) {
            this.next.eventHandler(event);
        }
    }

    boolean remove(Link link) {
        if (this.next == null) {
            return false;
        }
        if (this.next.firstLinkEqualsTo(link)) {
            this.next = this.next.next;
            return true;
        }
        return this.next.remove(link);
    }

    boolean firstLinkEqualsTo(Link link) {
        return this.link.equals(link);
    }
}

