/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven;

import java.util.Date;
import java.util.Map;
import org.mazarineblue.datasources.BlackboardSource;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.SourceChain;
import org.mazarineblue.datasources.SourceWrapper;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventService;
import org.mazarineblue.eventbus.SimpleEventService;
import org.mazarineblue.eventbus.exceptions.IllegalEventTypeException;
import org.mazarineblue.eventbus.exceptions.SubscriberTargetException;
import org.mazarineblue.events.EndSheetEvent;
import org.mazarineblue.events.StartSheetEvent;
import org.mazarineblue.events.instructions.ExecuteInstructionLineEvent;
import org.mazarineblue.events.instructions.ValidateInstructionLineEvent;
import org.mazarineblue.keyworddriven.DocumentMediator;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Interpreter;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.SheetFactory;
import org.mazarineblue.keyworddriven.chainmanager.ChainManager;
import org.mazarineblue.keyworddriven.exceptions.ConsumableException;
import org.mazarineblue.keyworddriven.exceptions.GenericFeedException;
import org.mazarineblue.keyworddriven.exceptions.IllegalFeedStateException;
import org.mazarineblue.keyworddriven.exceptions.InterpreterAlReadyRunningException;
import org.mazarineblue.keyworddriven.exceptions.InterpreterSetupException;
import org.mazarineblue.keyworddriven.feeds.Feed;
import org.mazarineblue.keyworddriven.librarymanager.DefaultLibrary;
import org.mazarineblue.keyworddriven.librarymanager.LibraryManager;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.proceduremanager.ProcedureManager;
import org.mazarineblue.parser.Parser;
import org.mazarineblue.parser.variable.VariableParser;

public class Processor
implements Interpreter {
    private final BlackboardSource blackboard = new BlackboardSource("Processor.BlackboardSource");
    private final SourceWrapper externalSource = new SourceWrapper();
    private final SourceChain chain = new SourceChain(new DataSource[]{this.blackboard, this.externalSource});
    private final InterpreterContext context;
    private final EventService<Event> eventService;
    private final LibraryManager libraryManager;
    private final ProcedureManager procedureManager;
    private final ChainManager chainManager;
    private int nested = 0;
    private long sleep = 0L;
    private Interpreter.State state = Interpreter.State.WAITING;
    private final Date startDate;
    private InstructionLine previousLine;

    public static ConsumableException convertException(Throwable ex) {
        return Processor.convertException(ex.getMessage(), ex);
    }

    public static ConsumableException convertException(String msg, Throwable ex) {
        if (ex.getCause() != null) {
            ex = ex.getCause();
        }
        return ex instanceof ConsumableException ? (ConsumableException)ex : new ConsumableException(msg, ex);
    }

    public Processor() {
        this(new Date());
    }

    public Processor(Date startDate) {
        this.startDate = startDate;
        this.eventService = Processor.createEventService();
        this.context = Processor.createContext(this.blackboard, this);
        this.procedureManager = new ProcedureManager();
        this.libraryManager = new LibraryManager(this.eventService, this.context);
        this.chainManager = new ChainManager(this.procedureManager, this.libraryManager, (Parser)new VariableParser(), this.eventService);
        this.libraryManager.register(new DefaultLibrary(this.eventService, this.procedureManager));
    }

    private static EventService createEventService() {
        try {
            return new SimpleEventService(Event.class);
        }
        catch (IllegalEventTypeException ex) {
            throw new InterpreterSetupException(ex);
        }
    }

    private static InterpreterContext createContext(BlackboardSource blackboard, Interpreter executor) {
        InterpreterContext context = new InterpreterContext();
        context.setBlackboard(blackboard);
        context.setExecutor(executor);
        return context;
    }

    @Override
    public void setSleep(long sleep) {
        if (sleep < 0L) {
            throw new IllegalArgumentException("Sleep needs to be greater or equal to 0.");
        }
        this.sleep = sleep;
    }

    @Override
    public LibraryManager libraries() {
        return this.libraryManager;
    }

    @Override
    public ProcedureManager procedures() {
        return this.procedureManager;
    }

    @Override
    public ChainManager chain() {
        return this.chainManager;
    }

    @Override
    public void publish(Event event) {
        this.chainManager.publish(event);
    }

    @Override
    public void setSource(DataSource externalSource) {
        this.externalSource.setSource(externalSource);
    }

    @Override
    public void execute(Feed feed, Log log, DocumentMediator documentMediator, SheetFactory sheetFactory, Map<String, Object> presetVariables) {
        new ExecuteInstructionHelper().doMain(feed, log, documentMediator, sheetFactory, presetVariables);
    }

    @Override
    public void executeNested(Feed feed, Log log, InterpreterContext context) {
        new ExecuteInstructionHelper().doNested(feed, log, context);
    }

    @Override
    public void validate(Feed feed, Log log, DocumentMediator documentMediator, SheetFactory sheetFactory) {
        new ValidateInstructionHelper().doMain(feed, log, documentMediator, sheetFactory, null);
    }

    @Override
    public void validateNested(Feed feed, Log log, InterpreterContext context) {
        new ValidateInstructionHelper().doNested(feed, log, context);
    }

    @Override
    public Interpreter.State getState() {
        return this.state;
    }

    @Override
    public void pause() {
        this.state = Interpreter.State.PAUSED;
    }

    @Override
    public void resume() {
        this.state = Interpreter.State.RUNNING;
    }

    @Override
    public void cancle() {
        this.state = Interpreter.State.CANCELED;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    private class ValidateInstructionHelper
    extends InstructionHelper {
        private ValidateInstructionHelper() {
        }

        @Override
        protected ProcessingType getProcessingType() {
            return ProcessingType.VALIDATED;
        }

        @Override
        protected Event createInstructionLineEvent(InstructionLine line) {
            ValidateInstructionLineEvent event = new ValidateInstructionLineEvent(line);
            event.setDataSource((DataSource)Processor.this.chain);
            event.setContext(Processor.this.context);
            return event;
        }

        @Override
        protected void sleep(Log log) {
        }

        @Override
        protected ConsumableException processException(Exception ex, Log log) {
            ConsumableException tex = Processor.convertException(ex);
            if (!tex.isConsumed()) {
                log.error(ex);
                tex.setConsumed();
            }
            return null;
        }
    }

    private class ExecuteInstructionHelper
    extends InstructionHelper {
        private ExecuteInstructionHelper() {
        }

        @Override
        protected ProcessingType getProcessingType() {
            return ProcessingType.EXECUTED;
        }

        @Override
        protected Event createInstructionLineEvent(InstructionLine line) {
            ExecuteInstructionLineEvent event = new ExecuteInstructionLineEvent(line);
            event.setDataSource((DataSource)Processor.this.chain);
            event.setContext(Processor.this.context);
            return event;
        }

        @Override
        protected void sleep(Log log) {
            try {
                Thread.sleep(Processor.this.sleep);
            }
            catch (InterruptedException ex) {
                log.warning(ex);
            }
        }

        @Override
        protected ConsumableException processException(Exception ex, Log log) {
            ConsumableException tex = Processor.convertException(ex);
            if (!tex.isConsumed()) {
                log.error(ex);
                tex.setConsumed();
            }
            return tex;
        }
    }

    private abstract class InstructionHelper {
        private InstructionHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doMain(Feed feed, Log log, DocumentMediator documentMediator, SheetFactory sheetFactory, Map<String, Object> presetVariables) {
            if (Processor.this.state != Interpreter.State.WAITING) {
                throw new InterpreterAlReadyRunningException();
            }
            this.publish((Event)new StartSheetEvent(null));
            try {
                Processor.this.state = Interpreter.State.RUNNING;
                Processor.this.context.set(feed, log, documentMediator, sheetFactory);
                Processor.this.blackboard.setup(presetVariables);
                this.doNested(feed, log, Processor.this.context);
            }
            finally {
                Processor.this.state = Interpreter.State.WAITING;
                Processor.this.context.set(null, null, null, null);
                Processor.this.blackboard.teardown();
                Processor.this.previousLine = null;
            }
            this.publish((Event)new EndSheetEvent(null));
        }

        private void publish(Event event) {
            try {
                Processor.this.chainManager.publish(event);
            }
            catch (SubscriberTargetException ex) {
                Throwable cause = ex.getCause();
                throw new ConsumableException(cause.getMessage(), cause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doNested(Feed feed, Log log, InterpreterContext context) {
            try {
                ++Processor.this.nested;
                this.incrementNestedInstruction(log, new Date());
                this.registerLibraries(context);
                this.doLines(feed, log, context);
            }
            finally {
                --Processor.this.nested;
                this.teardownLibraries();
                this.decrementNestedInstruction(log, new Date());
            }
        }

        private void incrementNestedInstruction(Log log, Date startDate) {
            if (Processor.this.nested != 1) {
                log.incrementNestedInstruction(startDate);
            }
        }

        private void decrementNestedInstruction(Log log, Date endDate) {
            if (Processor.this.nested != 0) {
                log.decrementNestedInstruction(endDate);
            }
        }

        private void registerLibraries(InterpreterContext context) {
            if (Processor.this.nested != 1) {
                return;
            }
            Processor.this.libraryManager.setup(context);
        }

        private void teardownLibraries() {
            if (Processor.this.nested == 0) {
                Processor.this.libraryManager.teardown();
            }
        }

        public final void doLines(Feed feed, Log log, InterpreterContext context) {
            try {
                while (feed.hasNext()) {
                    if (this.shouldAbort()) {
                        return;
                    }
                    InstructionLine line = feed.next();
                    this.doLine(line, log, context);
                    this.waitingForNonPausedState();
                }
            }
            catch (IllegalFeedStateException ex) {
                throw new GenericFeedException(ex.getMessage(), ex);
            }
            finally {
                if (feed.hasNext()) {
                    Processor.this.validateNested(feed, log, context);
                }
            }
        }

        private boolean shouldAbort() {
            return Processor.this.state == Interpreter.State.CANCELED;
        }

        private void waitingForNonPausedState() {
            if (Processor.this.state == Interpreter.State.PAUSED) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Processor.this.state = Interpreter.State.CANCELED;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doLine(InstructionLine line, Log log, InterpreterContext context) {
            if (Processor.this.previousLine != null && Processor.this.previousLine.isEmpty() && line.isEmpty()) {
                return;
            }
            try {
                this.setup(line, log, this.getProcessingType());
                Event event = this.createInstructionLineEvent(line);
                this.fireLineEvent(event, log);
                this.sleep(log);
            }
            finally {
                log.done(new Date());
                context.startDate(null);
                Processor.this.previousLine = line;
            }
        }

        private void setup(InstructionLine line, Log log, ProcessingType type) {
            try {
                Processor.this.context.startDate(new Date());
                Processor.this.context.clear(line);
                log.next(line, (DataSource)Processor.this.chain, Processor.this.context, type);
            }
            catch (IllegalSourceStateException ex) {
                throw this.processException((Exception)((Object)ex), log);
            }
        }

        private void fireLineEvent(Event event, Log log) {
            block2: {
                try {
                    Processor.this.chainManager.publish(event);
                }
                catch (RuntimeException ex) {
                    ConsumableException iex = this.processException(ex, log);
                    if (iex == null) break block2;
                    throw iex;
                }
            }
        }

        protected abstract ProcessingType getProcessingType();

        protected abstract Event createInstructionLineEvent(InstructionLine var1);

        protected abstract void sleep(Log var1);

        protected abstract ConsumableException processException(Exception var1, Log var2);
    }

    public static enum ProcessingType {
        EXECUTED,
        VALIDATED;

    }
}

