/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mazarineblue.datasources.BlackboardSource;
import org.mazarineblue.keyworddriven.DocumentMediator;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.Interpreter;
import org.mazarineblue.keyworddriven.SheetFactory;
import org.mazarineblue.keyworddriven.feeds.Feed;
import org.mazarineblue.keyworddriven.logs.Log;
import org.mazarineblue.keyworddriven.util.HasContext;

public class InterpreterContext
implements HasContext {
    private Interpreter executor;
    private Feed feed;
    private Log log;
    private BlackboardSource blackboard;
    private DocumentMediator documentMediator;
    private SheetFactory sheetFactory;
    private Date startDate;
    private final List<InstructionLine> lines = new ArrayList<InstructionLine>();

    InterpreterContext() {
    }

    InterpreterContext(Interpreter executor, BlackboardSource blackboard) {
        this.executor = executor;
        this.blackboard = blackboard;
    }

    private InterpreterContext(Interpreter executor, Feed feed, Log log, BlackboardSource blackboard, DocumentMediator documentMediator, SheetFactory sheetFactory) {
        this.executor = executor;
        this.feed = feed;
        this.log = log;
        this.blackboard = blackboard;
        this.documentMediator = documentMediator;
        this.sheetFactory = sheetFactory;
    }

    @Override
    public InterpreterContext context() {
        return this;
    }

    @Override
    public Interpreter executor() {
        return this.executor;
    }

    @Override
    public Feed feed() {
        return this.feed;
    }

    @Override
    public Log log() {
        return this.log;
    }

    @Override
    public BlackboardSource blackboard() {
        return this.blackboard;
    }

    @Override
    public DocumentMediator documentMediator() {
        return this.documentMediator;
    }

    @Override
    public SheetFactory sheetFactory() {
        return this.sheetFactory;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setExecutor(Interpreter executor) {
        this.executor = executor;
    }

    public void setBlackboard(BlackboardSource blackboard) {
        this.blackboard = blackboard;
    }

    void set(Feed feed, Log log, DocumentMediator documentMediator, SheetFactory sheetFactory) {
        this.feed = feed;
        this.log = log;
        this.documentMediator = documentMediator;
        this.sheetFactory = sheetFactory;
    }

    public void setFeed(Feed feed) {
        this.feed = feed;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setDocumentMediator(DocumentMediator documentMediator) {
        this.documentMediator = documentMediator;
    }

    public void setSheetFactory(SheetFactory sheetFactory) {
        this.sheetFactory = sheetFactory;
    }

    public void clear(InstructionLine line) {
        this.lines.clear();
        this.add(line);
    }

    public final void add(InstructionLine line) {
        this.lines.add(line);
    }

    public InstructionLine getUnprocessedLine() {
        return this.lines.get(0);
    }

    public InstructionLine[] getLines() {
        InstructionLine[] arr = new InstructionLine[this.lines.size()];
        return this.lines.toArray(arr);
    }
}

