/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven;

import java.util.Arrays;

public class InstructionLine {
    private final String lineIdenfitier;
    private final String namespace;
    private final String keyword;
    private final Object[] parameter;

    public InstructionLine(String lineIdentifier, String namespace, String keyword, Object ... parameters) {
        this.lineIdenfitier = lineIdentifier.trim();
        this.namespace = namespace.trim();
        this.keyword = keyword.trim();
        this.parameter = this.copyParameters(parameters, this.getLength(parameters));
    }

    private int getLength(Object[] parameters) {
        int n = 0;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].toString().isEmpty()) continue;
            n = i + 1;
        }
        return n;
    }

    private Object[] copyParameters(Object[] input, int n) {
        Object[] output = new Object[n];
        for (int i = 0; i < n; ++i) {
            output[i] = input[i] instanceof String ? ((String)input[i]).trim() : input[i];
        }
        return output;
    }

    public String toString() {
        String str = this.isPathEmpty() ? (this.parameter.length > 0 ? "Comment" : "") : this.namespace + '.' + this.keyword;
        for (int i = 0; i < this.parameter.length; ++i) {
            str = str + (i == 0 ? " (" : ", ");
            str = str + this.parameter[i].toString();
        }
        if (this.parameter.length != 0) {
            str = str + ")";
        }
        return str;
    }

    public boolean isEmpty() {
        return this.isPathEmpty() && this.parameter.length <= 0;
    }

    public String getLineIdentifier() {
        return this.lineIdenfitier;
    }

    public boolean isComment() {
        if (this.parameter.length <= 0) {
            return false;
        }
        return this.isPathEmpty();
    }

    public final boolean isPathEmpty() {
        return this.keyword.isEmpty() && this.namespace.isEmpty();
    }

    public String getPath() {
        return this.namespace + '.' + this.keyword;
    }

    public static String getNamespace(String path) {
        int pos = path.lastIndexOf(46);
        return pos < 1 ? "" : path.substring(0, pos);
    }

    public static String getKeyword(String path) {
        int pos = path.lastIndexOf(46);
        return pos < 0 ? path : path.substring(pos + 1);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public int countParameters() {
        return this.parameter.length;
    }

    public Object getParameter(int index) {
        return this.parameter[index];
    }

    public Object[] getParameters() {
        return Arrays.copyOf(this.parameter, this.parameter.length);
    }
}

