/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.keyworddriven;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.Date;
import org.mazarineblue.util.Timestamp;

public interface DocumentMediator {
    default public Timestamp getDefaultTimestamp() {
        return Timestamp.getDefaultInstance((String)"yyyy-MM-dd_HH-mm-ss");
    }

    default public String getDefaultFolder(Date date) {
        return this.getDefaultTimestamp().getTimestamp(date);
    }

    public String getInputLocation();

    public InputStream getInputStream() throws IOException;

    public InputStream getInputStream(Path var1) throws IOException;

    default public void writeLogOutput(String directory, String dummyName, String input) throws IOException {
        if (input == null) {
            return;
        }
        try (OutputStream output = this.getLogOutputStream(directory, dummyName);){
            output.write(input.getBytes());
        }
    }

    default public void writeReportOutput(String folder, String reportName, String input) throws IOException {
        if (input == null) {
            return;
        }
        try (OutputStream output = this.getReportOutputStream(folder, reportName);){
            output.write(input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    default public void writeOutput(Path path, String input) throws IOException {
        if (input == null) {
            return;
        }
        try (OutputStream output = this.getOutputStream(path);){
            output.write(input.getBytes());
        }
    }

    public OutputStream getLogOutputStream(String var1, String var2) throws IOException;

    public OutputStream getReportOutputStream(String var1, String var2) throws IOException;

    public OutputStream getOutputStream(Path var1) throws IOException;
}

