/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.events.instructions;

import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.eventbus.AbstractEvent;
import org.mazarineblue.keyworddriven.InstructionLine;
import org.mazarineblue.keyworddriven.InterpreterContext;
import org.mazarineblue.keyworddriven.librarymanager.Library;

public abstract class InstructionLineEvent
extends AbstractEvent {
    private InstructionLine line;
    private DataSource source;
    private InterpreterContext context;

    public InstructionLineEvent(InstructionLine line) {
        this.line = line;
    }

    public InstructionLineEvent(InstructionLine line, Library library) {
        this.line = line;
        this.source = library.blackboard();
        this.context = library.context();
    }

    public String toString() {
        return "InstructionLineEvent{line=" + this.line.toString() + "}";
    }

    public InstructionLine getLine() {
        return this.line;
    }

    public void push(InstructionLine line) {
        if (this.context != null) {
            this.context.add(line);
        }
        this.line = line;
    }

    public void setDataSource(DataSource source) {
        this.source = source;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public void setContext(InterpreterContext context) {
        this.context = context;
    }

    public InterpreterContext getContext() {
        return this.context;
    }
}

