/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Driver;
import org.mariadb.jdbc.plugin.authentication.AuthenticationPlugin;

public final class AuthenticationPluginLoader {
    public static AuthenticationPlugin get(String type, Configuration conf) throws SQLException {
        ServiceLoader<AuthenticationPlugin> loader = ServiceLoader.load(AuthenticationPlugin.class, Driver.class.getClassLoader());
        String restrictedAuth = conf.restrictedAuth() == null ? "mysql_native_password,client_ed25519,auth_gssapi_client" : conf.restrictedAuth();
        String[] authList = restrictedAuth.split(",");
        for (AuthenticationPlugin implClass : loader) {
            block4: {
                block3: {
                    if (!type.equals(implClass.type())) continue;
                    if ("none".equals(restrictedAuth)) break block3;
                    if (!Arrays.stream(authList).anyMatch(type::contains)) break block4;
                }
                return implClass;
            }
            throw new SQLException(String.format("Client restrict authentication plugin to a limited set of authentication plugin and doesn't permit requested plugin ('%s'). Current list is `restrictedAuth=%s`", type, restrictedAuth), "08004", 1251);
        }
        throw new SQLException("Client does not support authentication protocol requested by server. plugin type was = '" + type + "'", "08004", 1251);
    }
}

