/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketReader;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.message.server.Completion;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class PrepareResultPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(PrepareResultPacket.class);
    private final ColumnDefinitionPacket[] parameters;
    private ColumnDefinitionPacket[] columns;
    protected int statementId;

    public PrepareResultPacket(ReadableByteBuf buffer, PacketReader reader, Context context) throws IOException {
        int i;
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new ColumnDefinitionPacket[numParams];
        this.columns = new ColumnDefinitionPacket[numColumns];
        if (numParams > 0) {
            for (i = 0; i < numParams; ++i) {
                this.parameters[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
        if (numColumns > 0) {
            for (i = 0; i < numColumns; ++i) {
                this.columns[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
    }

    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnDefinitionPacket[] getParameters() {
        return this.parameters;
    }

    public ColumnDefinitionPacket[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnDefinitionPacket[] columns) {
        this.columns = columns;
    }
}

