/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults.resultset.value;

import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.mariadb.jdbc.internal.queryresults.resultset.value.ValueObject;
import org.mariadb.jdbc.internal.util.ExceptionMapper;

public abstract class AbstractValueObject
implements ValueObject {
    @Override
    public <T> T getObject(Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("getObject(Class<T> type) : type cannot be null", "HY105");
        }
        if (type.equals(String.class)) {
            return (T)this.getString();
        }
        if (type.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong());
        }
        if (type.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble());
        }
        if (type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt());
        }
        if (type.equals(Short.TYPE)) {
            return (T)Short.valueOf(this.getShort());
        }
        if (type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean());
        }
        if (type.equals(Byte.class)) {
            return (T)Byte.valueOf(this.getByte());
        }
        if (type.equals(Byte[].class)) {
            return (T)this.getBytes();
        }
        if (type.equals(Date.class)) {
            try {
                return (T)this.getDate(null);
            }
            catch (ParseException parseException) {
                throw ExceptionMapper.getSqlException("Could not parse column as date, was: \"" + this.getString() + "\"", parseException);
            }
        }
        if (type.equals(Time.class)) {
            try {
                return (T)this.getTime(null);
            }
            catch (ParseException parseException) {
                throw ExceptionMapper.getSqlException("Could not parse column as time, was: \"" + this.getString() + "\"", parseException);
            }
        }
        if (type.equals(Timestamp.class)) {
            try {
                return (T)this.getTimestamp(null);
            }
            catch (ParseException parseException) {
                throw ExceptionMapper.getSqlException("Could not parse column as timestamp, was: \"" + this.getString() + "\"", parseException);
            }
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal();
        }
        if (type.equals(Blob.class)) {
            return (T)this.getBlob();
        }
        if (type.equals(Clob.class)) {
            return (T)this.getClob();
        }
        if (type.equals(URL.class)) {
            try {
                return (T)new URL(this.getString());
            }
            catch (MalformedURLException e) {
                throw ExceptionMapper.getSqlException("Could not parse as URL");
            }
        }
        if (type.equals(Array.class)) {
            throw ExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
        }
        if (type.equals(SQLXML.class)) {
            throw ExceptionMapper.getFeatureNotSupportedException("SQLXMLs are not supported");
        }
        if (type.equals(NClob.class)) {
            throw ExceptionMapper.getFeatureNotSupportedException("NClobs are not supported");
        }
        if (type.equals(RowId.class)) {
            throw ExceptionMapper.getFeatureNotSupportedException("RowIds are not supported");
        }
        throw ExceptionMapper.getFeatureNotSupportedException("type " + type + " unknown");
    }
}

