/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults.resultset;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.RawPacket;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.read.ReadResultPacketFactory;
import org.mariadb.jdbc.internal.packet.result.BinaryRowPacket;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.ResultSetPacket;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.packet.result.TextRowPacket;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.resultset.AbstractSelectResultSet;
import org.mariadb.jdbc.internal.queryresults.resultset.value.GeneratedKeyValueObject;
import org.mariadb.jdbc.internal.queryresults.resultset.value.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.resultset.value.ValueObject;
import org.mariadb.jdbc.internal.util.ExceptionCode;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.buffer.ReadUtil;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaSelectResultSet
extends AbstractSelectResultSet {
    public static final MariaSelectResultSet EMPTY = MariaSelectResultSet.createEmptyResultSet();
    private ReadPacketFetcher packetFetcher;
    private boolean isEof;
    private boolean binaryProtocol;
    private int dataFetchTime;
    private RowPacket rowPacket;
    private boolean streaming;
    protected int columnInformationLength;
    protected List<ValueObject[]> resultSet;
    protected int fetchSize;
    protected int resultSetScrollType;
    protected MariaSelectResultSet moreResult;
    public boolean callableResult = false;

    public MariaSelectResultSet(ColumnInformation[] columnInformation, Statement statement, Protocol protocol, ReadPacketFetcher fetcher, boolean binaryProtocol, int resultSetScrollType, int fetchSize, boolean callableResult) {
        super(columnInformation, protocol, statement);
        this.columnInformationLength = columnInformation.length;
        this.packetFetcher = fetcher;
        this.isEof = false;
        this.binaryProtocol = binaryProtocol;
        this.fetchSize = fetchSize;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSet = new ArrayList<ValueObject[]>();
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = callableResult;
    }

    public MariaSelectResultSet(ColumnInformation[] columnInformation, List<ValueObject[]> resultSet, Protocol protocol, int resultSetScrollType) {
        super(columnInformation, protocol, null);
        this.columnInformationLength = columnInformation.length;
        this.isEof = false;
        this.binaryProtocol = false;
        this.fetchSize = 1;
        this.resultSetScrollType = resultSetScrollType;
        this.resultSet = resultSet;
        this.dataFetchTime = 0;
        this.rowPointer = -1;
    }

    public static ResultSet createGeneratedData(long[] data, Protocol protocol, boolean findColumnReturnsOne) {
        ColumnInformation[] columns = new ColumnInformation[]{ColumnInformation.create("insert_id", MariaDbType.BIGINT)};
        ArrayList<ValueObject[]> rows = new ArrayList<ValueObject[]>();
        long[] lArray = data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long rowData = lArray[i];
            if (rowData == 0L) continue;
            ValueObject[] row = new ValueObject[]{new GeneratedKeyValueObject(rowData)};
            rows.add(row);
        }
        if (findColumnReturnsOne) {
            return new MariaSelectResultSet(columns, rows, protocol, 1005){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new MariaSelectResultSet(columns, rows, protocol, 1005);
    }

    public static ResultSet createResultSet(String[] columnNames, MariaDbType[] columnTypes, String[][] data, Protocol protocol) {
        int columnNameLength = columnNames.length;
        ColumnInformation[] columns = new ColumnInformation[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        byte[] boolTrue = new byte[]{1};
        byte[] boolFalse = new byte[]{0};
        ArrayList<ValueObject[]> rows = new ArrayList<ValueObject[]>();
        for (String[] rowData : data) {
            ValueObject[] row = new ValueObject[columnNameLength];
            if (rowData.length != columnNameLength) {
                throw new RuntimeException("Number of elements in the row != number of columns :" + rowData.length + " vs " + columnNameLength);
            }
            for (int i = 0; i < columnNameLength; ++i) {
                byte[] bytes;
                if (rowData[i] == null) {
                    bytes = null;
                } else if (columnTypes[i] == MariaDbType.BIT) {
                    bytes = rowData[i].equals("0") ? boolFalse : boolTrue;
                } else {
                    try {
                        bytes = rowData[i].getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = new byte[]{};
                    }
                }
                row[i] = new MariaDbValueObject(bytes, columns[i], protocol.getOptions());
            }
            rows.add(row);
        }
        return new MariaSelectResultSet(columns, rows, protocol, 1005);
    }

    public static MariaSelectResultSet createResult(Statement statement, ResultSetPacket packet, ReadPacketFetcher packetFetcher, Protocol protocol, boolean binaryProtocol, int resultSetScrollType, int fetchSize, boolean canBeCallableResult) throws IOException, QueryException {
        boolean callableResult = false;
        if (protocol.getActiveResult() != null) {
            throw new QueryException("There is an active result set on the current connection, which must be closed prior to opening a new one");
        }
        long fieldCount = packet.getFieldCount();
        ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
        int i = 0;
        while ((long)i < fieldCount) {
            RawPacket rawPacket = packetFetcher.getRawPacket();
            ci[i] = new ColumnInformation(rawPacket.getByteBuffer());
            ++i;
        }
        ByteBuffer bufferEof = packetFetcher.getReusableBuffer();
        if (!ReadUtil.eofIsNext(bufferEof)) {
            throw new QueryException("Packets out of order when reading field packets, expected was EOF stream. Packet contents (hex) = " + MasterProtocol.hexdump(bufferEof, 0));
        }
        if (canBeCallableResult) {
            EndOfFilePacket endOfFilePacket = new EndOfFilePacket(bufferEof);
            callableResult = (endOfFilePacket.getStatusFlags() & ServerStatus.PS_OUT_PARAMETERS) != 0;
        }
        MariaSelectResultSet mariaSelectResultset = new MariaSelectResultSet(ci, statement, protocol, packetFetcher, binaryProtocol, resultSetScrollType, fetchSize, callableResult);
        mariaSelectResultset.initFetch();
        return mariaSelectResultset;
    }

    private static MariaSelectResultSet createEmptyResultSet() {
        return new MariaSelectResultSet(new ColumnInformation[0], new ArrayList<ValueObject[]>(), null, 1005);
    }

    public void initFetch() throws IOException, QueryException {
        this.rowPacket = this.binaryProtocol ? new BinaryRowPacket(this.columnsInformation, this.protocol.getOptions(), this.columnInformationLength) : new TextRowPacket(this.columnsInformation, this.protocol.getOptions(), this.columnInformationLength);
        if (this.fetchSize == 0 || this.resultSetScrollType != 1003) {
            this.fetchAllResults();
            this.streaming = false;
        } else {
            this.protocol.setActiveResult(this);
            this.streaming = true;
        }
    }

    @Override
    public boolean isBinaryProtocol() {
        return this.binaryProtocol;
    }

    private void fetchAllResults() throws IOException, QueryException {
        ArrayList<ValueObject[]> valueObjects = new ArrayList<ValueObject[]>();
        while (this.readNextValue(valueObjects)) {
        }
        ++this.dataFetchTime;
        this.resultSet = valueObjects;
    }

    private void nextStreamingValue() throws IOException, QueryException {
        ArrayList<ValueObject[]> valueObjects = new ArrayList<ValueObject[]>();
        for (int fetchSizeTmp = this.fetchSize; fetchSizeTmp > 0 && this.readNextValue(valueObjects); --fetchSizeTmp) {
        }
        ++this.dataFetchTime;
        this.resultSet = valueObjects;
    }

    public boolean readNextValue(List<ValueObject[]> values) throws IOException, QueryException {
        ByteBuffer buffer = this.packetFetcher.getReusableBuffer();
        byte initialByte = buffer.get(0);
        if (initialByte == -1) {
            this.protocol.setActiveResult(null);
            ErrorPacket errorPacket = (ErrorPacket)ReadResultPacketFactory.createResultPacket(buffer);
            throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        if (initialByte == -2 && buffer.limit() < 9) {
            EndOfFilePacket endOfFilePacket = (EndOfFilePacket)ReadResultPacketFactory.createResultPacket(buffer);
            if (this.protocol.getActiveResult() == this) {
                this.protocol.setActiveResult(null);
            }
            this.protocol.setHasWarnings(endOfFilePacket.getWarningCount() > 0);
            this.protocol.setMoreResults(this.callableResult || (endOfFilePacket.getStatusFlags() & ServerStatus.MORE_RESULTS_EXISTS) != 0, this.binaryProtocol);
            this.protocol = null;
            this.packetFetcher = null;
            this.isEof = true;
            return false;
        }
        values.add(this.rowPacket.getRow(this.packetFetcher, buffer));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        super.close();
        if (this.protocol != null && this.protocol.getActiveResult() == this) {
            ReentrantLock lock = this.protocol.getLock();
            lock.lock();
            try {
                try {
                    while (!this.isEof) {
                        ByteBuffer buffer = this.packetFetcher.getReusableBuffer();
                        byte initialByte = buffer.get(0);
                        if (initialByte == -1) {
                            this.protocol.setActiveResult(null);
                            ErrorPacket errorPacket = (ErrorPacket)ReadResultPacketFactory.createResultPacket(buffer);
                            throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
                        }
                        if (initialByte != -2 || buffer.limit() >= 9) continue;
                        EndOfFilePacket endOfFilePacket = (EndOfFilePacket)ReadResultPacketFactory.createResultPacket(buffer);
                        if (this.protocol.getActiveResult() == this) {
                            this.protocol.setActiveResult(null);
                        }
                        this.protocol.setHasWarnings(endOfFilePacket.getWarningCount() > 0);
                        this.protocol.setMoreResults((endOfFilePacket.getStatusFlags() & ServerStatus.MORE_RESULTS_EXISTS) != 0, this.binaryProtocol);
                        this.protocol = null;
                        this.packetFetcher = null;
                        this.isEof = true;
                    }
                }
                catch (IOException ioexception) {
                    throw new QueryException("Could not close resultset : " + ioexception.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioexception);
                }
            }
            catch (QueryException queryException) {
                ExceptionMapper.throwException(queryException, null, this.getStatement());
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        return this.internalNext();
    }

    private boolean internalNext() throws SQLException {
        if (this.rowPointer < this.resultSet.size() - 1) {
            ++this.rowPointer;
            return true;
        }
        if (this.streaming) {
            if (this.isEof) {
                return this.isEof;
            }
            try {
                this.nextStreamingValue();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            this.rowPointer = 0;
            return this.resultSet.size() > 0;
        }
        this.rowPointer = this.resultSet.size();
        return false;
    }

    @Override
    protected ValueObject getValueObject(int position) throws SQLException {
        if (this.rowPointer < 0) {
            this.throwError("Current position is before the first row", ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        if (this.rowPointer >= this.resultSet.size()) {
            this.throwError("Current position is after the last row", ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        ValueObject[] row = this.resultSet.get(this.rowPointer);
        if (position <= 0 || position > row.length) {
            this.throwError("No such column: " + position, ExceptionCode.INVALID_PARAMETER_VALUE);
        }
        ValueObject vo = row[position - 1];
        this.lastGetWasNull = vo.isNull();
        return vo;
    }

    private void throwError(String message, ExceptionCode exceptionCode) throws SQLException {
        if (this.statement == null) {
            throw new SQLException(message, exceptionCode.sqlState);
        }
        ExceptionMapper.throwException(new QueryException("Current position is before the first row", ExceptionCode.INVALID_PARAMETER_VALUE), (MariaDbConnection)this.statement.getConnection(), this.statement);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.rowPointer == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.dataFetchTime > 0) {
            return this.rowPointer >= this.resultSet.size() && this.resultSet.size() > 0;
        }
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime == 1 && this.rowPointer == 0 && this.resultSet.size() > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.dataFetchTime > 0 && this.isEof) {
            return this.rowPointer == this.resultSet.size() - 1 && this.resultSet.size() > 0;
        }
        if (this.streaming) {
            try {
                this.nextStreamingValue();
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            return this.rowPointer == this.resultSet.size() - 1 && this.resultSet.size() > 0;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = this.resultSet.size();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = 0;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = this.resultSet.size() - 1;
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.streaming) {
            return 0;
        }
        return this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (row >= 0 && row <= this.resultSet.size()) {
            this.rowPointer = row - 1;
            return true;
        }
        if (row < 0) {
            this.rowPointer = this.resultSet.size() + row;
        }
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        int newPos = this.rowPointer + rows;
        if (newPos > -1 && newPos <= this.resultSet.size()) {
            this.rowPointer = newPos;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (this.rowPointer > -1) {
            --this.rowPointer;
            return this.rowPointer != -1;
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001) {
            throw new SQLException("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (this.streaming && this.fetchSize == 0) {
            try {
                while (this.readNextValue(this.resultSet)) {
                }
            }
            catch (IOException ioException) {
                throw new SQLException(ioException);
            }
            catch (QueryException queryException) {
                throw new SQLException(queryException);
            }
            ++this.dataFetchTime;
            this.streaming = false;
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public MariaSelectResultSet getMoreResult() {
        return this.moreResult;
    }

    public void setMoreResult(MariaSelectResultSet moreResult) {
        this.moreResult = moreResult;
    }

    private void checkClose() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Operation not permit on a closed resultset", "HY000");
        }
    }

    public boolean isCallableResult() {
        return this.callableResult;
    }

    public void setCallableResult(boolean callableResult) {
        this.callableResult = callableResult;
    }
}

